/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.security.Principal;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.NfsLoginService;

public class NssIdmapper
implements NfsIdMapping,
NfsLoginService {
    private final String _domain;
    private static final int NOBODY_UID = 65534;
    private static final int NOBODY_GID = 65534;
    private static final String NOBODY_USER = "nobody";
    private static final String NOBODY_GROUP = "nobody";
    private final LibC _libc = (LibC)Native.loadLibrary((String)"c", LibC.class);

    public NssIdmapper(String domain) {
        this._domain = domain;
    }

    @Override
    public String gidToPrincipal(int id) {
        __group g = this._libc.getgrgid(id);
        if (g == null) {
            return "nobody";
        }
        return this.addDomain(g.name);
    }

    @Override
    public int principalToGid(String principal) {
        __group g = this._libc.getgrnam(this.stripDomain(principal));
        if (g == null) {
            return 65534;
        }
        return g.gid;
    }

    @Override
    public int principalToUid(String principal) {
        __password p = this._libc.getpwnam(this.stripDomain(principal));
        if (p == null) {
            return 65534;
        }
        return p.uid;
    }

    @Override
    public String uidToPrincipal(int id) {
        __password p = this._libc.getpwuid(id);
        if (p == null) {
            return "nobody";
        }
        return this.addDomain(p.name);
    }

    @Override
    public Subject login(Principal principal) {
        __password p = this._libc.getpwnam(this.stripDomain(principal.getName()));
        if (p == null) {
            return Subjects.NOBODY;
        }
        return Subjects.of((int)p.uid, (int)p.gid, (int[])this.groupsOf(p));
    }

    private int[] groupsOf(__password pwrecord) {
        boolean done = false;
        int[] groups2 = new int[]{};
        while (!done) {
            IntByReference ngroups = new IntByReference();
            ngroups.setValue(groups2.length);
            if (this._libc.getgrouplist(pwrecord.name, pwrecord.gid, groups2, ngroups) < 0) {
                groups2 = new int[ngroups.getValue()];
                continue;
            }
            done = true;
        }
        return groups2;
    }

    private String stripDomain(String s) {
        int n = s.indexOf(64);
        if (n != -1) {
            return s.substring(0, n);
        }
        return s;
    }

    private String addDomain(String s) {
        return s + "@" + this._domain;
    }

    public static interface LibC
    extends Library {
        public __password getpwnam(String var1);

        public __password getpwuid(int var1);

        public __group getgrnam(String var1);

        public __group getgrgid(int var1);

        public int getgrouplist(String var1, int var2, int[] var3, IntByReference var4);
    }

    public static class __group
    extends Structure {
        public String name;
        public String passwd;
        public int gid;
        public Pointer mem;
    }

    public static class __password
    extends Structure {
        public String name;
        public String passwd;
        public int uid;
        public int gid;
        public String gecos;
        public String dir;
        public String shell;
    }
}

