/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NameFilter;
import org.dcache.chimera.nfs.v4.xdr.REMOVE4res;
import org.dcache.chimera.nfs.v4.xdr.REMOVE4resok;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.vfs.Inode;
import org.dcache.chimera.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREMOVE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREMOVE.class);

    OperationREMOVE(nfs_argop4 args) {
        super(args, 28);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        REMOVE4res res = result.opremove;
        try {
            Inode parentInode = context.currentInode();
            Stat stat = context.getFs().getattr(parentInode);
            if (stat.type() != Stat.Type.DIRECTORY) {
                throw new ChimeraNFSException(20, "parent not a directory");
            }
            String name2 = NameFilter.convert(this._args.opremove.target.value.value.value);
            if (name2.length() > 255) {
                throw new ChimeraNFSException(63, "name too long");
            }
            if (name2.length() == 0) {
                throw new ChimeraNFSException(22, "zero-length name");
            }
            if (name2.equals(".") || name2.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            _log.debug("REMOVE: {} : {}", (Object)parentInode, (Object)name2);
            boolean rc = context.getFs().remove(parentInode, name2);
            if (!rc && context.getFs().getattr(context.getFs().lookup(parentInode, name2)).type() == Stat.Type.DIRECTORY) {
                throw new ChimeraNFSException(66, "directory not empty");
            }
            res.status = 0;
            res.resok4 = new REMOVE4resok();
            res.resok4.cinfo = new change_info4();
            res.resok4.cinfo.atomic = true;
            res.resok4.cinfo.before = new changeid4(new uint64_t(stat.getMTime()));
            res.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
        }
        catch (FileNotFoundHimeraFsException e) {
            res.status = 2;
        }
    }
}

