/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcache.chimera.nfs.v4.xdr.GETATTR4args;
import org.dcache.chimera.nfs.v4.xdr.bitmap4;
import org.dcache.chimera.nfs.v4.xdr.fattr4;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fs_locations;
import org.dcache.chimera.nfs.v4.xdr.fattr4_lease_time;
import org.dcache.chimera.nfs.v4.xdr.fattr4_type;
import org.dcache.chimera.nfs.v4.xdr.mode4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cs;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrBuffer;
import org.dcache.xdr.XdrDecodingStream;

public class GetattrStub {
    public static nfs_argop4 generateRequest(int ... attrs) {
        nfs_argop4 op = new nfs_argop4();
        GETATTR4args args = new GETATTR4args();
        args.attr_request = bitmap4.of(attrs);
        op.argop = 9;
        op.opgetattr = args;
        return op;
    }

    public static List<Integer> supportedAttrs(bitmap4 bitmap) {
        ArrayList<Integer> supported = new ArrayList<Integer>();
        return supported;
    }

    public static Attrs decodeType(fattr4 attributes) throws OncRpcException, IOException {
        HashMap<Integer, Object> attr = new HashMap<Integer, Object>();
        int[] mask = new int[attributes.attrmask.value.length];
        for (int i = 0; i < mask.length; ++i) {
            mask[i] = attributes.attrmask.value[i].value;
        }
        XdrBuffer xdr = new XdrBuffer(attributes.attr_vals.value);
        xdr.beginDecoding();
        if (mask.length != 0) {
            int maxAttr = 32 * mask.length;
            for (int i = 0; i < maxAttr; ++i) {
                int newmask = mask[i / 32] >> i - 32 * (i / 32);
                if (((long)newmask & 1L) == 0L) continue;
                GetattrStub.xdr2fattr(attr, i, (XdrDecodingStream)xdr);
            }
        }
        xdr.endDecoding();
        return new Attrs(attr);
    }

    static void xdr2fattr(Map<Integer, Object> attr, int fattr, XdrDecodingStream xdr) throws OncRpcException, IOException {
        switch (fattr) {
            case 4: {
                uint64_t size = new uint64_t();
                size.xdrDecode(xdr);
                attr.put(fattr, size);
                break;
            }
            case 33: {
                mode4 mode = new mode4();
                mode.xdrDecode(xdr);
                attr.put(fattr, mode);
                break;
            }
            case 36: {
                utf8str_cs owner = new utf8str_cs();
                owner.xdrDecode(xdr);
                String new_owner = owner.toString();
                attr.put(fattr, new_owner);
                break;
            }
            case 37: {
                utf8str_cs owner_group = new utf8str_cs();
                owner_group.xdrDecode(xdr);
                String new_group = owner_group.toString();
                attr.put(fattr, new_group);
                break;
            }
            case 1: {
                fattr4_type type = new fattr4_type();
                type.xdrDecode(xdr);
                attr.put(fattr, type);
                break;
            }
            case 24: {
                fattr4_fs_locations fs_locations = new fattr4_fs_locations();
                fs_locations.xdrDecode(xdr);
                attr.put(fattr, fs_locations);
                break;
            }
            case 10: {
                attr.put(fattr, new fattr4_lease_time(xdr));
            }
        }
    }

    public static class Attrs {
        private final Map<Integer, Object> _attrs;

        public Attrs(Map<Integer, Object> attrs) {
            this._attrs = attrs;
        }

        public <T> T get(Integer attr) {
            return (T)this._attrs.get(attr);
        }
    }
}

