/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.nfsstat;
import org.dcache.chimera.nfs.v4.Stateids;
import org.dcache.chimera.nfs.v4.client.CompoundBuilder;
import org.dcache.chimera.nfs.v4.client.FileIoDevice;
import org.dcache.chimera.nfs.v4.client.GetDeviceListStub;
import org.dcache.chimera.nfs.v4.client.GetattrStub;
import org.dcache.chimera.nfs.v4.client.LayoutgetStub;
import org.dcache.chimera.nfs.v4.client.Stripe;
import org.dcache.chimera.nfs.v4.client.StripeMap;
import org.dcache.chimera.nfs.v4.client.nfs4_prot_NFS4_PROGRAM_Client;
import org.dcache.chimera.nfs.v4.xdr.COMPOUND4args;
import org.dcache.chimera.nfs.v4.xdr.COMPOUND4res;
import org.dcache.chimera.nfs.v4.xdr.clientid4;
import org.dcache.chimera.nfs.v4.xdr.deviceid4;
import org.dcache.chimera.nfs.v4.xdr.entry4;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fs_locations;
import org.dcache.chimera.nfs.v4.xdr.fattr4_lease_time;
import org.dcache.chimera.nfs.v4.xdr.fattr4_type;
import org.dcache.chimera.nfs.v4.xdr.layout4;
import org.dcache.chimera.nfs.v4.xdr.mode4;
import org.dcache.chimera.nfs.v4.xdr.nfs_fh4;
import org.dcache.chimera.nfs.v4.xdr.nfsv4_1_file_layout4;
import org.dcache.chimera.nfs.v4.xdr.nfsv4_1_file_layout_ds_addr4;
import org.dcache.chimera.nfs.v4.xdr.sequenceid4;
import org.dcache.chimera.nfs.v4.xdr.sessionid4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.chimera.nfs.vfs.Stat;
import org.dcache.utils.Bytes;
import org.dcache.xdr.OncRpcException;

public class Main {
    private final nfs4_prot_NFS4_PROGRAM_Client _nfsClient;
    private final Map<deviceid4, FileIoDevice> _knowDevices = new HashMap<deviceid4, FileIoDevice>();
    private nfs_fh4 _cwd = null;
    private nfs_fh4 _rootFh = null;
    private nfs_fh4 _ioFH = null;
    private clientid4 _clientIdByServer = null;
    private sequenceid4 _sequenceID = null;
    private sessionid4 _sessionid = null;
    private long _lastUpdate = -1L;
    private boolean _isMDS = false;
    private boolean _isDS = false;
    private static final String PROMPT = "NFSv41: ";
    private final ScheduledExecutorService _executorService = Executors.newScheduledThreadPool(1);
    private final LoadingCache<InetSocketAddress, Main> _servers = CacheBuilder.newBuilder().build((CacheLoader)new Connector());

    public static void main(String[] args) throws IOException, OncRpcException, InterruptedException {
        String line;
        System.out.println("Started the NFS4 Client ....");
        Main nfsClient = null;
        String[] commands = new String[]{"mount", "cd", "ls", "lookup", "mkdir", "read", "readatonce", "filebomb", "remove", "umount", "write", "fs_locations", "getattr"};
        PrintWriter out = new PrintWriter(System.out);
        ConsoleReader reader = new ConsoleReader(System.in, (Writer)out);
        reader.setUseHistory(true);
        LinkedList<SimpleCompletor> completors = new LinkedList<SimpleCompletor>();
        completors.add(new SimpleCompletor(commands));
        reader.addCompletor((Completor)new ArgumentCompletor(completors));
        if (args.length > 0) {
            HostAndPort hp = HostAndPort.fromString((String)args[0]).withDefaultPort(2049).requireBracketsForIPv6();
            InetSocketAddress serverAddress = new InetSocketAddress(hp.getHostText(), hp.getPort());
            nfsClient = new Main(serverAddress);
            nfsClient.mount("/");
        }
        while ((line = reader.readLine(PROMPT)) != null) {
            if ((line = line.trim()).length() == 0) continue;
            String[] commandArgs = line.split("[ \t]+");
            try {
                if (commandArgs[0].equals("mount")) {
                    String host = commandArgs.length > 1 ? commandArgs[1] : "localhost";
                    String root = commandArgs.length > 2 ? commandArgs[2] : "/";
                    nfsClient = new Main(InetAddress.getByName(host));
                    nfsClient.mount(root);
                } else if (commandArgs[0].equals("umount")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    nfsClient.umount();
                    nfsClient = null;
                } else if (commandArgs[0].equals("ls")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length == 2) {
                        nfsClient.readdir(commandArgs[1]);
                    } else {
                        nfsClient.readdir();
                    }
                } else if (commandArgs[0].equals("cd")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: cd <path>");
                        continue;
                    }
                    nfsClient.cwd(commandArgs[1]);
                } else if (commandArgs[0].equals("lookup")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: lookup <path>");
                        continue;
                    }
                    nfsClient.lookup(commandArgs[1]);
                } else if (commandArgs[0].equals("getattr")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: getattr <path>");
                        continue;
                    }
                    nfsClient.getattr(commandArgs[1]);
                } else if (commandArgs[0].equals("mkdir")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: mkdir <path>");
                        continue;
                    }
                    nfsClient.mkdir(commandArgs[1]);
                } else if (commandArgs[0].equals("read")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: read <file>");
                        continue;
                    }
                    nfsClient.read(commandArgs[1]);
                } else if (commandArgs[0].equals("readatonce")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: readatonce <file>");
                        continue;
                    }
                    nfsClient.readatonce(commandArgs[1]);
                } else if (commandArgs[0].equals("fs_locations")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: fs_locations <file>");
                        continue;
                    }
                    nfsClient.get_fs_locations(commandArgs[1]);
                } else if (commandArgs[0].equals("remove")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: remove <file>");
                        continue;
                    }
                    nfsClient.remove(commandArgs[1]);
                } else if (commandArgs[0].equals("write")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 3) {
                        System.out.println("usage: write <src> <dest>");
                        continue;
                    }
                    nfsClient.write(commandArgs[1], commandArgs[2]);
                } else if (commandArgs[0].equals("filebomb")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    if (commandArgs.length != 2) {
                        System.out.println("usage: filebomb <num>");
                        continue;
                    }
                    nfsClient.filebomb(Integer.parseInt(commandArgs[1]));
                } else if (commandArgs[0].equals("gc")) {
                    if (nfsClient == null) {
                        System.out.println("Not mounted");
                        continue;
                    }
                    nfsClient.gc();
                } else if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) {
                    if (nfsClient != null) {
                        nfsClient.destroy_session();
                        nfsClient.destroy_clientid();
                    }
                    System.exit(0);
                } else {
                    out.println("Supported commands: ");
                    for (String command : commands) {
                        out.println("    " + command);
                    }
                }
                out.flush();
            }
            catch (ChimeraNFSException e) {
                out.printf("%s failed: %s(%d) \n", commandArgs[0], nfsstat.toString(e.getStatus()), e.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filebomb(int count) throws OncRpcException, IOException {
        ArrayList<String> files = new ArrayList<String>(count);
        long start = System.currentTimeMillis();
        try {
            for (int i = 0; i < count; ++i) {
                String file = UUID.randomUUID().toString();
                this.write("/etc/profile", file);
                files.add(file);
            }
        }
        finally {
            for (String file : files) {
                System.out.println("Remove: " + file);
                this.remove(file);
            }
            System.out.println(count + " files in " + (System.currentTimeMillis() - start) / 1000L);
        }
    }

    private void gc() throws OncRpcException, IOException {
        this.exchange_id();
        this.create_session();
        this.sequence();
    }

    private boolean needUpdate() {
        return System.currentTimeMillis() - this._lastUpdate > 60000L;
    }

    public Main(InetAddress host) throws OncRpcException, IOException {
        this._nfsClient = new nfs4_prot_NFS4_PROGRAM_Client(host, 6);
        this._servers.asMap().put(this._nfsClient.getTransport().getRemoteSocketAddress(), this);
    }

    public Main(InetSocketAddress address) throws OncRpcException, IOException {
        this._nfsClient = new nfs4_prot_NFS4_PROGRAM_Client(address.getAddress(), address.getPort(), 6);
        this._servers.asMap().put(address, this);
    }

    public void mount(String root) throws OncRpcException, IOException {
        this.exchange_id();
        this.create_session();
        this.getRootFh(root);
        this.get_supported_attributes();
        if (this._isMDS) {
            this.get_devicelist();
        }
        this._lastUpdate = System.currentTimeMillis();
    }

    public void dsMount() throws OncRpcException, IOException {
        this.exchange_id();
        this.create_session();
        this._lastUpdate = System.currentTimeMillis();
    }

    public void umount() throws OncRpcException, IOException {
        this.destroy_session();
        this.destroy_clientid();
    }

    private void exchange_id() throws OncRpcException, IOException {
        String domain = "nairi.desy.de";
        String name2 = "dCache.ORG java based client";
        COMPOUND4args args = new CompoundBuilder().withExchangeId(domain, name2, UUID.randomUUID().toString(), 0, 0).withTag("exchange_id").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        if (compound4res.resarray.get((int)0).opexchange_id.eir_resok4.eir_server_impl_id.length > 0) {
            String serverId = compound4res.resarray.get((int)0).opexchange_id.eir_resok4.eir_server_impl_id[0].nii_name.toString();
            System.out.println("Connected to: " + serverId);
        } else {
            System.out.println("Connected to: Mr. X");
        }
        this._clientIdByServer = compound4res.resarray.get((int)0).opexchange_id.eir_resok4.eir_clientid;
        this._sequenceID = compound4res.resarray.get((int)0).opexchange_id.eir_resok4.eir_sequenceid;
        if ((compound4res.resarray.get((int)0).opexchange_id.eir_resok4.eir_flags.value & 0x20000) != 0) {
            this._isMDS = true;
        }
        if ((compound4res.resarray.get((int)0).opexchange_id.eir_resok4.eir_flags.value & 0x40000) != 0) {
            this._isDS = true;
        }
        System.out.println("pNFS MDS: " + this._isMDS);
        System.out.println("pNFS  DS: " + this._isDS);
    }

    private void create_session() throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withCreatesession(this._clientIdByServer, this._sequenceID).withTag("create_session").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        this._sessionid = compound4res.resarray.get((int)0).opcreate_session.csr_resok4.csr_sessionid;
        this._sequenceID.value.value = 0;
        args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutrootfh().withGetattr(10).withTag("get_lease_time").build();
        compound4res = this.sendCompound(args);
        GetattrStub.Attrs attrs = GetattrStub.decodeType(compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opgetattr.resok4.obj_attributes);
        fattr4_lease_time leaseTime = (fattr4_lease_time)attrs.get(10);
        int leaseTimeInSeconds = leaseTime.value.value.value;
        System.out.println("server lease time: " + leaseTimeInSeconds + " sec.");
        this._executorService.scheduleAtFixedRate(new LeaseUpdater(this), leaseTimeInSeconds, leaseTimeInSeconds, TimeUnit.SECONDS);
    }

    private void destroy_session() throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withDestroysession(this._sessionid).withTag("destroy_session").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        this._executorService.shutdown();
    }

    private void destroy_clientid() throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withDestroyclientid(this._clientIdByServer).withTag("destroy_clientid").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        this._nfsClient.close();
    }

    private void getRootFh(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutrootfh().withLookup(path).withGetfh().withTag("get_rootfh").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        this._cwd = this._rootFh = compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opgetfh.resok4.object;
        System.out.println("root fh = " + Bytes.toHexString((byte[])this._rootFh.value));
    }

    public void readdir() throws OncRpcException, IOException {
        for (String entry : this.list(this._cwd)) {
            System.out.println(entry);
        }
    }

    public void readdir(String path) throws OncRpcException, IOException {
        for (String entry : this.list(this._cwd, path)) {
            System.out.println(entry);
        }
    }

    public String[] list(nfs_fh4 fh) throws OncRpcException, IOException, ChimeraNFSException {
        boolean done;
        ArrayList<String> list = new ArrayList<String>();
        long cookie = 0L;
        verifier4 verifier = new verifier4(new byte[8]);
        do {
            COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withReaddir(cookie, verifier).withTag("readdir").build();
            COMPOUND4res compound4res = this.sendCompound(args);
            verifier = compound4res.resarray.get((int)2).opreaddir.resok4.cookieverf;
            done = compound4res.resarray.get((int)2).opreaddir.resok4.reply.eof;
            entry4 dirEntry = compound4res.resarray.get((int)2).opreaddir.resok4.reply.entries;
            while (dirEntry != null) {
                cookie = dirEntry.cookie.value.value;
                list.add(new String(dirEntry.name.value.value.value));
                dirEntry = dirEntry.nextentry;
            }
        } while (!done);
        return list.toArray(new String[list.size()]);
    }

    public String[] list(nfs_fh4 fh, String path) throws OncRpcException, IOException, ChimeraNFSException {
        boolean done;
        ArrayList<String> list = new ArrayList<String>();
        long cookie = 0L;
        verifier4 verifier = new verifier4(new byte[8]);
        do {
            COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(path.charAt(0) == '/' ? this._rootFh : fh).withLookup(path).withReaddir(cookie, verifier).withTag("readdir").build();
            COMPOUND4res compound4res = this.sendCompound(args);
            verifier = compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opreaddir.resok4.cookieverf;
            done = compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opreaddir.resok4.reply.eof;
            entry4 dirEntry = compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opreaddir.resok4.reply.entries;
            while (dirEntry != null) {
                cookie = dirEntry.cookie.value.value;
                list.add(new String(dirEntry.name.value.value.value));
                dirEntry = dirEntry.nextentry;
            }
        } while (!done);
        return list.toArray(new String[list.size()]);
    }

    private void mkdir(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._cwd).withSavefh().withGetattr(3).withMakedir(path).withRestorefh().withGetattr(3).withTag("mkdir").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private void get_fs_locations(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._cwd).withLookup(path).withGetattr(24).withTag("get_fs_locations").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        GetattrStub.Attrs attrs = GetattrStub.decodeType(compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opgetattr.resok4.obj_attributes);
        fattr4_fs_locations locations = (fattr4_fs_locations)attrs.get(24);
        if (locations != null) {
            System.out.println("fs_locations fs_root: " + locations.value.fs_root.value[0].value.toString());
            System.out.println("fs_locations locations rootpath: " + locations.value.locations[0].rootpath.value[0].value.toString());
            System.out.println("fs_locations locations server: " + new String(locations.value.locations[0].server[0].value.value));
        }
    }

    nfs_fh4 cwd(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(path.charAt(0) == '/' ? this._rootFh : this._cwd).withLookup(path).withGetfh().withTag("lookup (cwd)").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        this._cwd = compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opgetfh.resok4.object;
        System.out.println("CWD fh = " + Bytes.toHexString((byte[])this._cwd.value));
        return new nfs_fh4(this._cwd.value);
    }

    public Stat stat(nfs_fh4 fh) throws OncRpcException, IOException {
        Stat stat = new Stat();
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withGetattr(4, 1).withTag("getattr (stat)").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        GetattrStub.Attrs attrs = GetattrStub.decodeType(compound4res.resarray.get((int)2).opgetattr.resok4.obj_attributes);
        uint64_t size = (uint64_t)attrs.get(4);
        if (size != null) {
            stat.setSize(size.value);
        }
        fattr4_type type = (fattr4_type)attrs.get(1);
        System.out.println("Type is: " + type.value);
        return stat;
    }

    private void read(String path) throws OncRpcException, IOException {
        OpenReply or = this.open(path);
        if (this._isMDS) {
            StripeMap stripeMap = this.layoutget(or.fh(), or.stateid(), 1);
            List<Stripe> stripes = stripeMap.getStripe(0L, 4096L);
            Stripe stripe = stripes.get(0);
            deviceid4 device = stripe.getDeviceId();
            FileIoDevice ioDevice = this._knowDevices.get(device);
            InetSocketAddress deviceAddr = ioDevice.of(stripe.getPatternOffset(), stripe.getUnit(), 0L, 4096, stripe.getFirstStripeIndex());
            Main dsClient = (Main)this._servers.getUnchecked((Object)deviceAddr);
            dsClient.nfsRead(stripe.getFh(), or.stateid());
            this.layoutreturn(or.fh(), 0L, -1L, new byte[0], stripeMap.getStateid());
        } else {
            this.nfsRead(or.fh(), or.stateid());
        }
        this.close(or.fh(), or.stateid());
    }

    private void readatonce(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(path.charAt(0) == '/' ? this._rootFh : this._cwd).withLookup(Main.dirname(path)).withOpen(Main.basename(path), this._sequenceID.value.value, this._clientIdByServer, 1).withRead(4096, 0L, Stateids.currentStateId()).withClose(Stateids.currentStateId()).withTag("open+read+close").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        int opss = compound4res.resarray.size();
        byte[] data = new byte[compound4res.resarray.get((int)(opss - 2)).opread.resok4.data.remaining()];
        compound4res.resarray.get((int)(opss - 2)).opread.resok4.data.get(data);
        System.out.println("[" + new String(data) + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String source, String path) throws OncRpcException, IOException {
        File f = new File(source);
        if (!f.exists()) {
            System.out.println("file not found: " + f);
        }
        OpenReply or = this.create(path);
        if (this._isMDS) {
            StripeMap stripeMap = this.layoutget(or.fh(), or.stateid(), 2);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(source, "r");
                byte[] data = new byte[4096];
                long offset = 0L;
                while (true) {
                    int n;
                    if ((n = raf.read(data)) == -1) {
                    }
                    if (n < data.length) {
                        byte[] b = new byte[n];
                        System.arraycopy(data, 0, b, 0, n);
                    }
                    List<Stripe> stripes = stripeMap.getStripe(offset, 4096L);
                    Stripe stripe = stripes.get(0);
                    deviceid4 device = stripe.getDeviceId();
                    FileIoDevice ioDevice = this._knowDevices.get(device);
                    InetSocketAddress deviceAddr = ioDevice.of(stripe.getPatternOffset(), stripe.getUnit(), offset, data.length, stripe.getFirstStripeIndex());
                    Main dsClient = (Main)this._servers.getUnchecked((Object)deviceAddr);
                    dsClient.nfsWrite(stripe.getFh(), data, offset, or.stateid());
                    offset += (long)n;
                }
            }
            catch (IOException ie) {
                System.out.println("Write failed: " + ie.getMessage());
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
                this.layoutreturn(or.fh(), 0L, -1L, new byte[0], stripeMap.getStateid());
            }
        } else {
            this.nfsWrite(or.fh(), "hello world".getBytes(), 0L, or.stateid());
        }
        this.close(or.fh(), or.stateid());
    }

    private OpenReply open(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(path.charAt(0) == '/' ? this._rootFh : this._cwd).withLookup(Main.dirname(path)).withOpen(Main.basename(path), this._sequenceID.value.value, this._clientIdByServer, 1).withGetfh().withTag("open_read").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        int opCount = compound4res.resarray.size();
        nfs_fh4 fh = compound4res.resarray.get((int)(opCount - 1)).opgetfh.resok4.object;
        stateid4 stateid = compound4res.resarray.get((int)(opCount - 2)).opopen.resok4.stateid;
        System.out.println("open_read fh = " + Bytes.toHexString((byte[])fh.value));
        return new OpenReply(fh, stateid);
    }

    private OpenReply create(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(path.charAt(0) == '/' ? this._rootFh : this._cwd).withLookup(Main.dirname(path)).withOpenCreate(Main.basename(path), this._sequenceID.value.value, this._clientIdByServer, 3).withGetfh().withTag("open_create").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        int opCount = compound4res.resarray.size();
        nfs_fh4 fh = compound4res.resarray.get((int)(opCount - 1)).opgetfh.resok4.object;
        stateid4 stateid = compound4res.resarray.get((int)(opCount - 2)).opopen.resok4.stateid;
        System.out.println("open_read fh = " + Bytes.toHexString((byte[])fh.value));
        return new OpenReply(fh, stateid);
    }

    private void close(nfs_fh4 fh, stateid4 stateid) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withClose(stateid).withTag("close").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private StripeMap layoutget(nfs_fh4 fh, stateid4 stateid, int layoutiomode) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withLayoutget(false, 1, layoutiomode, 0, -1, 255, 8, stateid).withTag("layoutget").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        layout4[] layout = compound4res.resarray.get((int)2).oplayoutget.logr_resok4.logr_layout;
        System.out.println("Layoutget for fh: " + Bytes.toHexString((byte[])fh.value));
        System.out.println("    roc   : " + compound4res.resarray.get((int)2).oplayoutget.logr_resok4.logr_return_on_close);
        StripeMap stripeMap = new StripeMap(compound4res.resarray.get((int)2).oplayoutget.logr_resok4.logr_stateid);
        for (layout4 l : layout) {
            nfsv4_1_file_layout4 fileDevice = LayoutgetStub.decodeLayoutId(l.lo_content.loc_body);
            System.out.println("       sd # " + Arrays.toString(fileDevice.nfl_deviceid.value) + " size " + fileDevice.nfl_deviceid.value.length);
            this._ioFH = fileDevice.nfl_fh_list[0];
            System.out.println("     io fh: " + Bytes.toHexString((byte[])this._ioFH.value));
            System.out.println("    length: " + l.lo_length.value.value);
            System.out.println("    offset: " + l.lo_offset.value.value);
            System.out.println("    type  : " + l.lo_content.loc_type);
            System.out.println("    unit  : " + fileDevice.nfl_util.value.value);
            System.out.println("    commit: " + ((fileDevice.nfl_util.value.value & 2) == 0 ? "ds" : "mds"));
            deviceid4 deviceID = fileDevice.nfl_deviceid;
            Stripe stripe = new Stripe(deviceID, fileDevice.nfl_fh_list[0], l.lo_length.value.value, l.lo_offset.value.value, fileDevice.nfl_pattern_offset.value.value, fileDevice.nfl_util.value.value, fileDevice.nfl_first_stripe_index.value);
            stripeMap.addStripe(stripe);
            if (!this._knowDevices.containsKey(deviceID)) {
                System.out.println("    new: true");
                this.get_deviceinfo(deviceID);
            } else {
                System.out.println("    new: false");
            }
            FileIoDevice address = this._knowDevices.get(deviceID);
            if (address == null) {
                System.out.println("    address: failed to get");
                continue;
            }
            System.out.println("    address: " + address);
        }
        return stripeMap;
    }

    private void layoutreturn(nfs_fh4 fh, long offset, long len, byte[] body, stateid4 stateid) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withLayoutreturn(offset, len, body, stateid).withTag("layoutreturn").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private COMPOUND4res sendCompound(COMPOUND4args compound4args) throws OncRpcException, IOException {
        COMPOUND4res compound4res;
        do {
            compound4res = this._nfsClient.NFSPROC4_COMPOUND_4(compound4args);
            this.processSequence(compound4res);
            if (compound4res.status != 10013) continue;
            System.out.println("Server in GRACE period....retry");
        } while (compound4res.status == 10013);
        if (compound4res.status != 0) {
            throw new ChimeraNFSException(compound4res.status, "");
        }
        return compound4res;
    }

    private void get_deviceinfo(deviceid4 deviceId) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withGetdeviceinfo(deviceId).withTag("get_deviceinfo").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        nfsv4_1_file_layout_ds_addr4 addr = GetDeviceListStub.decodeFileDevice(compound4res.resarray.get((int)1).opgetdeviceinfo.gdir_resok4.gdir_device_addr.da_addr_body);
        this._knowDevices.put(deviceId, new FileIoDevice(addr));
    }

    private void get_devicelist() throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._rootFh).withGetdevicelist().withTag("get_devicelist").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        deviceid4[] deviceList = compound4res.resarray.get((int)2).opgetdevicelist.gdlr_resok4.gdlr_deviceid_list;
        System.out.println("Know devices: ");
        for (deviceid4 device : deviceList) {
            System.out.println("      Device: # " + Arrays.toString(device.value));
        }
    }

    private void nfsRead(nfs_fh4 fh, stateid4 stateid) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withRead(4096, 0L, stateid).withTag("pNFS read").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        byte[] data = new byte[compound4res.resarray.get((int)2).opread.resok4.data.remaining()];
        compound4res.resarray.get((int)2).opread.resok4.data.get(data);
        System.out.println("[" + new String(data) + "]");
    }

    private void nfsWrite(nfs_fh4 fh, byte[] data, long offset, stateid4 stateid) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(fh).withWrite(offset, data, stateid).withTag("pNFS write").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private void sequence() throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withTag("sequence").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private void get_supported_attributes() throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._rootFh).withGetattr(3).withTag("get_supported_attributes").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    public void remove(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._cwd).withRemove(path).withTag("remove").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private void lookup(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._cwd).withSavefh().withLookup(path).withGetfh().withGetattr(3, 4, 53).withRestorefh().withGetattr(3, 4, 53).withTag("lookup-sun").build();
        COMPOUND4res compound4res = this.sendCompound(args);
    }

    private void getattr(String path) throws OncRpcException, IOException {
        COMPOUND4args args = new CompoundBuilder().withSequence(false, this._sessionid, this._sequenceID.value.value, 12, 0).withPutfh(this._cwd).withLookup(path).withGetattr(3, 4, 53, 33).withTag("getattr").build();
        COMPOUND4res compound4res = this.sendCompound(args);
        GetattrStub.Attrs attrs = GetattrStub.decodeType(compound4res.resarray.get((int)(compound4res.resarray.size() - 1)).opgetattr.resok4.obj_attributes);
        mode4 mode = (mode4)attrs.get(33);
        if (mode != null) {
            System.out.println("mode: 0" + Integer.toOctalString(mode.value.value));
        }
    }

    public void processSequence(COMPOUND4res compound4res) {
        if (compound4res.resarray.get((int)0).resop == 53 && compound4res.resarray.get((int)0).opsequence.sr_status == 0) {
            this._lastUpdate = System.currentTimeMillis();
            ++this._sequenceID.value.value;
        }
    }

    private static String basename(String path) {
        File f = new File(path);
        return f.getName();
    }

    private static String dirname(String path) {
        File f = new File(path);
        String parent = f.getParent();
        return parent == null ? "/" : parent;
    }

    private static class Connector
    extends CacheLoader<InetSocketAddress, Main> {
        private Connector() {
        }

        public Main load(InetSocketAddress f) {
            try {
                Main client = new Main(f);
                client.dsMount();
                return client;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class OpenReply {
        private final nfs_fh4 _fh;
        private final stateid4 _stateid;

        private OpenReply(nfs_fh4 fh, stateid4 stateid) {
            this._stateid = stateid;
            this._fh = fh;
        }

        nfs_fh4 fh() {
            return this._fh;
        }

        stateid4 stateid() {
            return this._stateid;
        }
    }

    private static class LeaseUpdater
    implements Runnable {
        private final Main _nfsClient;

        LeaseUpdater(Main nfsClient) {
            this._nfsClient = nfsClient;
        }

        @Override
        public void run() {
            try {
                if (this._nfsClient.needUpdate()) {
                    this._nfsClient.sequence();
                }
            }
            catch (OncRpcException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

