/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.vfs;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.Who;
import org.dcache.auth.Subjects;
import org.dcache.chimera.DirectoryStreamHelper;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.JdbcFs;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.acl.Acls;
import org.dcache.chimera.nfs.v4.xdr.aceflag4;
import org.dcache.chimera.nfs.v4.xdr.acemask4;
import org.dcache.chimera.nfs.v4.xdr.acetype4;
import org.dcache.chimera.nfs.v4.xdr.nfsace4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_mixed;
import org.dcache.chimera.nfs.vfs.DirectoryEntry;
import org.dcache.chimera.nfs.vfs.Inode;
import org.dcache.chimera.nfs.vfs.Stat;
import org.dcache.chimera.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChimeraVfs
implements VirtualFileSystem {
    private static final Logger _log = LoggerFactory.getLogger(ChimeraVfs.class);
    private final JdbcFs _fs;
    private final NfsIdMapping _idMapping;

    public ChimeraVfs(JdbcFs fs, NfsIdMapping idMapping) {
        this._fs = fs;
        this._idMapping = idMapping;
    }

    @Override
    public Inode getRootInode() throws IOException {
        return this.toInode(FsInode.getRoot((FileSystemProvider)this._fs));
    }

    @Override
    public Inode lookup(Inode parent, String path) throws IOException {
        try {
            FsInode parentFsInode = this.toFsInode(parent);
            FsInode fsInode = parentFsInode.inodeOf(path);
            return this.toInode(fsInode);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new ChimeraNFSException(2, "Path Do not exist.");
        }
    }

    @Override
    public Inode create(Inode parent, Stat.Type type, String path, int uid, int gid, int mode) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        FsInode fsInode = this._fs.createFile(parentFsInode, path, uid, gid, mode | this.typeToChimera(type), this.typeToChimera(type));
        return this.toInode(fsInode);
    }

    @Override
    public Inode mkdir(Inode parent, String path, int uid, int gid, int mode) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        FsInode fsInode = parentFsInode.mkdir(path, uid, gid, mode);
        return this.toInode(fsInode);
    }

    @Override
    public Inode link(Inode parent, Inode link, String path, int uid, int gid) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        FsInode linkInode = this.toFsInode(link);
        FsInode fsInode = this._fs.createHLink(parentFsInode, linkInode, path);
        return this.toInode(fsInode);
    }

    @Override
    public Inode symlink(Inode parent, String path, String link, int uid, int gid, int mode) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        FsInode fsInode = this._fs.createLink(parentFsInode, path, uid, gid, mode, link.getBytes());
        return this.toInode(fsInode);
    }

    @Override
    public int read(Inode inode, byte[] data, long offset, int count) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.read(offset, data, 0, count);
    }

    @Override
    public void move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        FsInode from = this.toFsInode(src);
        FsInode to = this.toFsInode(dest);
        this._fs.move(from, oldName, to, newName);
    }

    @Override
    public String readlink(Inode inode) throws IOException {
        int count;
        byte[] data;
        FsInode fsInode = this.toFsInode(inode);
        int n = this._fs.read(fsInode, 0L, data = new byte[count = (int)fsInode.statCache().getSize()], 0, count);
        if (n < 0) {
            throw new IOException("Can't read symlink");
        }
        return new String(data, 0, n);
    }

    @Override
    public boolean remove(Inode parent, String path) throws IOException {
        FsInode parentFsInode = this.toFsInode(parent);
        return this._fs.remove(parentFsInode, path);
    }

    @Override
    public int write(Inode inode, byte[] data, long offset, int count) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.write(offset, data, 0, count);
    }

    @Override
    public List<DirectoryEntry> list(Inode inode) throws IOException {
        FsInode parentFsInode = this.toFsInode(inode);
        List list = DirectoryStreamHelper.listOf((FsInode)parentFsInode);
        return Lists.transform((List)list, (Function)new ChimeraDirectoryEntryToVfs());
    }

    @Override
    public Inode parentOf(Inode inode) throws IOException {
        return this.toInode(this.toFsInode(inode).getParent());
    }

    @Override
    public org.dcache.chimera.nfs.vfs.FsStat getFsStat() throws IOException {
        FsStat fsStat = this._fs.getFsStat();
        return new org.dcache.chimera.nfs.vfs.FsStat(fsStat.getTotalSpace(), fsStat.getTotalFiles(), fsStat.getUsedSpace(), fsStat.getUsedFiles());
    }

    private FsInode toFsInode(Inode inode) throws IOException {
        return this._fs.inodeFromBytes(inode.getFileId());
    }

    private Inode toInode(FsInode inode) {
        return Inode.forFile(inode.toFullString().getBytes());
    }

    @Override
    public Stat getattr(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        try {
            return ChimeraVfs.fromChimeraStat(fsInode.stat(), fsInode.id());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new ChimeraNFSException(2, "Path Do not exist.");
        }
    }

    @Override
    public void setattr(Inode inode, Stat stat) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        this._fs.setInodeAttributes(fsInode, 0, ChimeraVfs.toChimeraStat(stat));
    }

    @Override
    public nfsace4[] getAcl(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        List dacl = this._fs.getACL(fsInode);
        org.dcache.chimera.posix.Stat stat = this._fs.stat(fsInode);
        nfsace4[] unixAcl = Acls.of(stat.getMode(), fsInode.isDirectory());
        nfsace4[] aces = new nfsace4[dacl.size() + unixAcl.length];
        int i = 0;
        for (ACE ace : dacl) {
            aces[i] = ChimeraVfs.valueOf(ace, this._idMapping);
            ++i;
        }
        System.arraycopy(unixAcl, 0, aces, i, unixAcl.length);
        return Acls.compact(aces);
    }

    @Override
    public void setAcl(Inode inode, nfsace4[] acl) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        ArrayList<ACE> dacl = new ArrayList<ACE>();
        for (nfsace4 ace : acl) {
            dacl.add(ChimeraVfs.valueOf(ace, this._idMapping));
        }
        this._fs.setACL(fsInode, dacl);
    }

    private static Stat fromChimeraStat(org.dcache.chimera.posix.Stat pStat, long fileid) {
        Stat stat = new Stat();
        stat.setATime(pStat.getATime());
        stat.setCTime(pStat.getCTime());
        stat.setMTime(pStat.getMTime());
        stat.setGid(pStat.getGid());
        stat.setUid(pStat.getUid());
        stat.setDev(pStat.getDev());
        stat.setIno(pStat.getIno());
        stat.setMode(pStat.getMode());
        stat.setNlink(pStat.getNlink());
        stat.setRdev(pStat.getRdev());
        stat.setSize(pStat.getSize());
        stat.setFileid(fileid);
        return stat;
    }

    private static org.dcache.chimera.posix.Stat toChimeraStat(Stat stat) {
        org.dcache.chimera.posix.Stat pStat = new org.dcache.chimera.posix.Stat();
        pStat.setATime(stat.getATime());
        pStat.setCTime(stat.getCTime());
        pStat.setMTime(stat.getMTime());
        pStat.setGid(stat.getGid());
        pStat.setUid(stat.getUid());
        pStat.setDev(stat.getDev());
        pStat.setIno(stat.getIno());
        pStat.setMode(stat.getMode());
        pStat.setNlink(stat.getNlink());
        pStat.setRdev(stat.getRdev());
        pStat.setSize(stat.getSize());
        return pStat;
    }

    @Override
    public int access(Inode inode, int mode) throws IOException {
        return mode;
    }

    @Override
    public boolean hasIOLayout(Inode inode) throws IOException {
        FsInode fsInode = this.toFsInode(inode);
        return fsInode.type() == FsInodeType.INODE;
    }

    private int typeToChimera(Stat.Type type) {
        switch (type) {
            case SYMLINK: {
                return 40960;
            }
            case DIRECTORY: {
                return 16384;
            }
            case SOCK: {
                return 49152;
            }
            case FIFO: {
                return 4096;
            }
            case BLOCK: {
                return 24576;
            }
            case CHAR: {
                return 8192;
            }
        }
        return 32768;
    }

    private static nfsace4 valueOf(ACE ace, NfsIdMapping idMapping) {
        String principal;
        switch (ace.getWho()) {
            case USER: {
                principal = idMapping.uidToPrincipal(ace.getWhoID());
                break;
            }
            case GROUP: {
                principal = idMapping.gidToPrincipal(ace.getWhoID());
                break;
            }
            default: {
                principal = ace.getWho().getAbbreviation();
            }
        }
        nfsace4 nfsace = new nfsace4();
        nfsace.access_mask = new acemask4(new uint32_t(ace.getAccessMsk()));
        nfsace.flag = new aceflag4(new uint32_t(ace.getFlags()));
        nfsace.type = new acetype4(new uint32_t(ace.getType().getValue()));
        nfsace.who = new utf8str_mixed(principal);
        return nfsace;
    }

    private static ACE valueOf(nfsace4 ace, NfsIdMapping idMapping) {
        String principal = ace.who.toString();
        int type = ace.type.value.value;
        int flags = ace.flag.value.value;
        int mask = ace.access_mask.value.value;
        int id = -1;
        Who who = Who.fromAbbreviation((String)principal);
        if (who == null) {
            boolean isGroup = AceFlags.IDENTIFIER_GROUP.matches(flags);
            if (isGroup) {
                who = Who.GROUP;
                id = idMapping.principalToGid(principal);
            } else {
                who = Who.USER;
                id = idMapping.principalToUid(principal);
            }
        }
        return new ACE(AceType.valueOf((int)type), flags, mask, who, id, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
    }

    boolean checkAclAccess(Subject subject, Inode inode, int access) throws ChimeraNFSException, IOException {
        FsInode fsInode = this.toFsInode(inode);
        List acl = this._fs.getACL(fsInode);
        org.dcache.chimera.posix.Stat stat = this._fs.stat(fsInode);
        return this.checkAcl(subject, acl, stat.getUid(), stat.getGid(), access);
    }

    private boolean checkAcl(Subject subject, List<ACE> acl, int owner, int group, int access) throws ChimeraNFSException {
        for (ACE ace : acl) {
            Who who;
            int ace_mask;
            int flag = ace.getFlags();
            if ((flag & 8) != 0 || ace.getType() != AceType.ACCESS_ALLOWED_ACE_TYPE && ace.getType() != AceType.ACCESS_DENIED_ACE_TYPE || ((ace_mask = ace.getAccessMsk()) & access) == 0 || (who = ace.getWho()) != Who.EVERYONE && !(who == Who.OWNER & Subjects.hasUid((Subject)subject, (long)owner)) && !(who == Who.OWNER_GROUP & Subjects.hasGid((Subject)subject, (long)group)) && !(who == Who.GROUP & Subjects.hasGid((Subject)subject, (long)ace.getWhoID())) && !(who == Who.USER & Subjects.hasUid((Subject)subject, (long)ace.getWhoID()))) continue;
            if (ace.getType() == AceType.ACCESS_DENIED_ACE_TYPE) {
                _log.warn("Access deny: {} {}", (Object)subject, (Object)acemask4.toString(access));
                throw new ChimeraNFSException(13, "");
            }
            _log.debug("Access grant: {} {}", (Object)subject, (Object)acemask4.toString(access));
            return true;
        }
        return false;
    }

    private class ChimeraDirectoryEntryToVfs
    implements Function<HimeraDirectoryEntry, DirectoryEntry> {
        private ChimeraDirectoryEntryToVfs() {
        }

        public DirectoryEntry apply(HimeraDirectoryEntry e) {
            return new DirectoryEntry(e.getName(), ChimeraVfs.this.toInode(e.getInode()), ChimeraVfs.fromChimeraStat(e.getStat(), e.getInode().id()));
        }
    }
}

