/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.vfs;

import java.util.Arrays;
import org.dcache.chimera.nfs.vfs.FileHandle;

public class Inode {
    FileHandle fh;

    public Inode(byte[] bytes) {
        this.fh = new FileHandle(bytes);
    }

    public Inode(FileHandle h) {
        this.fh = h;
    }

    static Inode forFile(byte[] bytes) {
        return new Inode(new FileHandle.FileHandleBuilder().build(bytes));
    }

    public byte[] getFileId() {
        return this.fh.getFsOpaque();
    }

    public byte[] toNfsHandle() {
        return this.fh.bytes();
    }

    public int hashCode() {
        return Arrays.hashCode(this.fh.bytes());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Inode other = (Inode)obj;
        return Arrays.equals(this.fh.bytes(), other.fh.bytes());
    }

    public boolean isPesudoInode() {
        return this.fh.getType() == 1;
    }

    public int exportIndex() {
        return this.fh.getExportIdx();
    }

    public int handleVersion() {
        return this.fh.getVersion();
    }

    public String toString() {
        return this.fh.toString();
    }
}

