/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils;

import java.util.Date;

public class CacheElement<V> {
    private final long _maxLifeTime;
    private final long _idleTime;
    private final long _creationTime;
    private long _lastAccessTime;
    private final V _inner;

    CacheElement(V inner, long maxLifeTime, long idleTime) {
        this._lastAccessTime = this._creationTime = System.currentTimeMillis();
        this._inner = inner;
        this._maxLifeTime = maxLifeTime;
        this._idleTime = idleTime;
    }

    V getObject() {
        this._lastAccessTime = System.currentTimeMillis();
        return this._inner;
    }

    boolean validAt(long time) {
        return time - this._lastAccessTime < this._idleTime && time - this._creationTime < this._maxLifeTime;
    }

    public String toString() {
        long now = System.currentTimeMillis();
        return String.format("Element: [%s], created: %s, last access: %s, life time %d, idle: %d, max idle: %d", this._inner.toString(), new Date(this._creationTime), new Date(this._lastAccessTime), this._maxLifeTime, now - this._lastAccessTime, this._idleTime);
    }
}

