/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging;

import java.util.HashMap;
import java.util.Map;
import liquibase.exception.ServiceNotFoundException;
import liquibase.logging.Logger;
import liquibase.servicelocator.ServiceLocator;

public class LogFactory {
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static String defaultLoggingLevel = "info";

    public static Logger getLogger(String name2) {
        if (!loggers.containsKey(name2)) {
            Logger value;
            try {
                value = (Logger)ServiceLocator.getInstance().newInstance(Logger.class);
            }
            catch (Exception e) {
                throw new ServiceNotFoundException(e);
            }
            value.setName(name2);
            value.setLogLevel(defaultLoggingLevel);
            loggers.put(name2, value);
        }
        return loggers.get(name2);
    }

    public static Logger getLogger() {
        return LogFactory.getLogger("liquibase");
    }

    public static void setLoggingLevel(String defaultLoggingLevel) {
        LogFactory.defaultLoggingLevel = defaultLoggingLevel;
    }
}

