/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

import java.util.HashMap;
import java.util.Map;

public enum AceType {
    ACCESS_ALLOWED_ACE_TYPE(0, "A"),
    ACCESS_DENIED_ACE_TYPE(1, "D"),
    ACCESS_AUDIT_ACE_TYPE(2, "U"),
    ACCESS_ALARM_ACE_TYPE(2, "L");

    private final int _value;
    private final String _abbreviation;
    private static final Map<String, AceType> _valuesByAbb;
    private static final Map<Integer, AceType> _valuesByValue;

    private AceType(int value, String abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public String getAbbreviation() {
        return this._abbreviation;
    }

    public String toString() {
        return String.valueOf(this._abbreviation);
    }

    public static AceType fromAbbreviation(String abbreviation) throws IllegalArgumentException {
        AceType aceType = _valuesByAbb.get(abbreviation);
        if (aceType == null) {
            throw new IllegalArgumentException("Invalid ACE type abbreviation: " + abbreviation);
        }
        return aceType;
    }

    public static AceType valueOf(int value) throws IllegalArgumentException {
        AceType aceType = _valuesByValue.get(value);
        if (aceType == null) {
            throw new IllegalArgumentException("Invalid ACE type value: " + Integer.toHexString(value));
        }
        return aceType;
    }

    static {
        _valuesByAbb = new HashMap<String, AceType>();
        _valuesByValue = new HashMap<Integer, AceType>();
        for (AceType aceType : AceType.values()) {
            _valuesByAbb.put(aceType.getAbbreviation(), aceType);
            _valuesByValue.put(aceType.getValue(), aceType);
        }
    }
}

