/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_CONST
extends FsInode {
    private static final String _title = "\n >> Chimera FS Engine Version 0.0.8 $Rev$ << \n";
    private final byte[] _version;

    public FsInode_CONST(FileSystemProvider fs, String cnst) {
        super(fs, cnst, FsInodeType.CONST);
        StringBuilder sb = new StringBuilder(_title);
        sb.append("\n").append(this._fs.getInfo()).append("\n");
        this._version = sb.toString().getBytes();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        if (pos > (long)this._version.length) {
            return 0;
        }
        int copyLen = Math.min(len, this._version.length - (int)pos);
        System.arraycopy(this._version, (int)pos, data, 0, copyLen);
        return copyLen;
    }

    @Override
    public void setATime(long atime) throws ChimeraFsException {
    }

    @Override
    public void setCTime(long ctime) throws ChimeraFsException {
    }

    @Override
    public void setGID(int gid) throws ChimeraFsException {
    }

    @Override
    public void setMode(int mode) throws ChimeraFsException {
    }

    @Override
    public void setMTime(long mtime) throws ChimeraFsException {
    }

    @Override
    public void setSize(long size) throws ChimeraFsException {
    }

    @Override
    public void setUID(int uid) throws ChimeraFsException {
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = new Stat();
        ret.setNlink(1);
        ret.setMode(33060);
        ret.setSize(this._version.length);
        ret.setATime(System.currentTimeMillis());
        ret.setMTime(ret.getATime());
        ret.setCTime(ret.getATime());
        return ret;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }
}

