/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.base.Splitter;
import java.net.InetAddress;
import org.dcache.chimera.nfs.IPMatcher;

public class FsExport {
    private final String _path;
    private final String _client;
    private final Root _isTrusted;
    private final IO _rw;
    private final boolean _withAcl;
    private final Sec _sec;

    public FsExport(String path, String client, Root isTrusted, IO rw, boolean withAcl, Sec sec) {
        this._path = path;
        this._client = client;
        this._isTrusted = isTrusted;
        this._rw = rw;
        this._withAcl = withAcl;
        this._sec = sec;
    }

    public String getPath() {
        return this._path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._path).append(':').append(' ').append(this._client).append('(').append((Object)this._rw).append(',').append((Object)this._isTrusted).append(',').append(this._withAcl ? "acl" : "noacl").append(',').append("sec=").append((Object)this._sec).append(')').append(':').append("idx=").append(Integer.toHexString(this.getIndex()));
        return sb.toString();
    }

    public boolean isAllowed(InetAddress client) {
        return client.isLoopbackAddress() || IPMatcher.match(this._client, client);
    }

    public boolean isTrusted(InetAddress client) {
        return this.isAllowed(client) && this._isTrusted == Root.TRUSTED;
    }

    public boolean isTrusted() {
        return this._isTrusted == Root.TRUSTED;
    }

    public String client() {
        return this._client;
    }

    public IO ioMode() {
        return this._rw;
    }

    public int getIndex() {
        int index = 1;
        for (String s : Splitter.on('/').omitEmptyStrings().split(this._path)) {
            index = 31 * index + s.hashCode();
        }
        return index;
    }

    public boolean checkAcls() {
        return this._withAcl;
    }

    public Sec getSec() {
        return this._sec;
    }

    public static class FsExportBuilder {
        private String _client = "*";
        private IO _io = IO.RO;
        private Root _isTrusted = Root.NOTTRUSTED;
        private boolean _withAcl = false;
        private Sec _sec = Sec.SYS;

        public FsExportBuilder forClient(String client) {
            this._client = client;
            return this;
        }

        public FsExportBuilder trusted() {
            this._isTrusted = Root.TRUSTED;
            return this;
        }

        public FsExportBuilder notTrusted() {
            this._isTrusted = Root.NOTTRUSTED;
            return this;
        }

        public FsExportBuilder ro() {
            this._io = IO.RO;
            return this;
        }

        public FsExportBuilder rw() {
            this._io = IO.RW;
            return this;
        }

        public FsExportBuilder withAcl() {
            this._withAcl = true;
            return this;
        }

        public FsExportBuilder withoutAcl() {
            this._withAcl = false;
            return this;
        }

        public FsExportBuilder withSec(Sec sec) {
            this._sec = sec;
            return this;
        }

        public FsExport build(String path) {
            return new FsExport(path, this._client, this._isTrusted, this._io, this._withAcl, this._sec);
        }
    }

    public static enum Sec {
        NONE,
        SYS,
        KRB5,
        KRB5I,
        KRB5P;

    }

    public static enum IO {
        RW,
        RO;

    }

    public static enum Root {
        TRUSTED,
        NOTTRUSTED;

    }
}

