/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.dcache.chimera.nfs.v4.xdr.CLOSE4args;
import org.dcache.chimera.nfs.v4.xdr.COMPOUND4args;
import org.dcache.chimera.nfs.v4.xdr.CREATE4args;
import org.dcache.chimera.nfs.v4.xdr.CREATE_SESSION4args;
import org.dcache.chimera.nfs.v4.xdr.DESTROY_CLIENTID4args;
import org.dcache.chimera.nfs.v4.xdr.DESTROY_SESSION4args;
import org.dcache.chimera.nfs.v4.xdr.EXCHANGE_ID4args;
import org.dcache.chimera.nfs.v4.xdr.GETATTR4args;
import org.dcache.chimera.nfs.v4.xdr.GETDEVICEINFO4args;
import org.dcache.chimera.nfs.v4.xdr.GETDEVICELIST4args;
import org.dcache.chimera.nfs.v4.xdr.LAYOUTGET4args;
import org.dcache.chimera.nfs.v4.xdr.LAYOUTRETURN4args;
import org.dcache.chimera.nfs.v4.xdr.LOOKUP4args;
import org.dcache.chimera.nfs.v4.xdr.OPEN4args;
import org.dcache.chimera.nfs.v4.xdr.PUTFH4args;
import org.dcache.chimera.nfs.v4.xdr.READ4args;
import org.dcache.chimera.nfs.v4.xdr.READDIR4args;
import org.dcache.chimera.nfs.v4.xdr.REMOVE4args;
import org.dcache.chimera.nfs.v4.xdr.SEQUENCE4args;
import org.dcache.chimera.nfs.v4.xdr.WRITE4args;
import org.dcache.chimera.nfs.v4.xdr.attrlist4;
import org.dcache.chimera.nfs.v4.xdr.bitmap4;
import org.dcache.chimera.nfs.v4.xdr.callback_sec_parms4;
import org.dcache.chimera.nfs.v4.xdr.channel_attrs4;
import org.dcache.chimera.nfs.v4.xdr.client_owner4;
import org.dcache.chimera.nfs.v4.xdr.clientid4;
import org.dcache.chimera.nfs.v4.xdr.component4;
import org.dcache.chimera.nfs.v4.xdr.count4;
import org.dcache.chimera.nfs.v4.xdr.createhow4;
import org.dcache.chimera.nfs.v4.xdr.createtype4;
import org.dcache.chimera.nfs.v4.xdr.deviceid4;
import org.dcache.chimera.nfs.v4.xdr.fattr4;
import org.dcache.chimera.nfs.v4.xdr.fattr4_mode;
import org.dcache.chimera.nfs.v4.xdr.fattr4_size;
import org.dcache.chimera.nfs.v4.xdr.int64_t;
import org.dcache.chimera.nfs.v4.xdr.layoutreturn4;
import org.dcache.chimera.nfs.v4.xdr.layoutreturn_file4;
import org.dcache.chimera.nfs.v4.xdr.length4;
import org.dcache.chimera.nfs.v4.xdr.mode4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_cookie4;
import org.dcache.chimera.nfs.v4.xdr.nfs_fh4;
import org.dcache.chimera.nfs.v4.xdr.nfs_impl_id4;
import org.dcache.chimera.nfs.v4.xdr.nfstime4;
import org.dcache.chimera.nfs.v4.xdr.offset4;
import org.dcache.chimera.nfs.v4.xdr.open_claim4;
import org.dcache.chimera.nfs.v4.xdr.open_owner4;
import org.dcache.chimera.nfs.v4.xdr.openflag4;
import org.dcache.chimera.nfs.v4.xdr.seqid4;
import org.dcache.chimera.nfs.v4.xdr.sequenceid4;
import org.dcache.chimera.nfs.v4.xdr.sessionid4;
import org.dcache.chimera.nfs.v4.xdr.slotid4;
import org.dcache.chimera.nfs.v4.xdr.state_owner4;
import org.dcache.chimera.nfs.v4.xdr.state_protect4_a;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cis;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cs;
import org.dcache.chimera.nfs.v4.xdr.utf8string;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.utils.Bytes;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrBuffer;
import org.glassfish.grizzly.Buffer;

public class CompoundBuilder {
    private final utf8string NO_TAG;
    private utf8string tag;
    private int minorversion;
    private List<nfs_argop4> ops;

    public CompoundBuilder() {
        this.tag = this.NO_TAG = new utf8string(new byte[0]);
        this.minorversion = 1;
        this.ops = new ArrayList<nfs_argop4>();
    }

    public CompoundBuilder withTag(String tag) {
        this.tag = new utf8string(tag);
        return this;
    }

    public CompoundBuilder withLookup(String path) {
        Splitter splitter = Splitter.on('/').omitEmptyStrings();
        for (String s : splitter.split(path)) {
            if ("..".equals(s)) {
                this.withLookupp();
                continue;
            }
            nfs_argop4 op = new nfs_argop4();
            op.argop = 15;
            op.oplookup = new LOOKUP4args();
            op.oplookup.objname = new component4(new utf8str_cs(s));
            this.ops.add(op);
        }
        return this;
    }

    public CompoundBuilder withPutfh(nfs_fh4 fh) {
        nfs_argop4 op = new nfs_argop4();
        op.opputfh = new PUTFH4args();
        op.opputfh.object = fh;
        op.argop = 22;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withReaddir(long cookie, verifier4 verifier) {
        nfs_argop4 op = new nfs_argop4();
        op.opreaddir = new READDIR4args();
        op.opreaddir.cookie = new nfs_cookie4(new uint64_t(cookie));
        op.opreaddir.dircount = new count4(new uint32_t(8192));
        op.opreaddir.maxcount = new count4(new uint32_t(256));
        op.opreaddir.attr_request = new bitmap4(new uint32_t[]{new uint32_t(0), new uint32_t(0)});
        op.opreaddir.cookieverf = verifier;
        op.argop = 26;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withGetfh() {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 10;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withExchangeId(String nii_domain, String nii_name, String co_ownerid, int flags, int how) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 42;
        op.opexchange_id = new EXCHANGE_ID4args();
        op.opexchange_id.eia_client_impl_id = new nfs_impl_id4[1];
        nfs_impl_id4 n4 = new nfs_impl_id4();
        n4.nii_domain = new utf8str_cis(nii_domain);
        n4.nii_name = new utf8str_cs(nii_name);
        op.opexchange_id.eia_client_impl_id[0] = n4;
        nfstime4 releaseDate = new nfstime4();
        releaseDate.nseconds = new uint32_t(0);
        releaseDate.seconds = new int64_t(System.currentTimeMillis() / 1000L);
        op.opexchange_id.eia_client_impl_id[0].nii_date = releaseDate;
        op.opexchange_id.eia_clientowner = new client_owner4();
        op.opexchange_id.eia_clientowner.co_ownerid = co_ownerid.getBytes();
        op.opexchange_id.eia_clientowner.co_verifier = new verifier4();
        op.opexchange_id.eia_clientowner.co_verifier.value = new byte[8];
        Bytes.putLong(op.opexchange_id.eia_clientowner.co_verifier.value, 0, releaseDate.seconds.value);
        op.opexchange_id.eia_flags = new uint32_t(flags);
        op.opexchange_id.eia_state_protect = new state_protect4_a();
        op.opexchange_id.eia_state_protect.spa_how = how;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withPutrootfh() {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 24;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withLookupp() {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 16;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withMinorversion(int minorversion) {
        this.minorversion = minorversion;
        return this;
    }

    public CompoundBuilder withCreatesession(clientid4 clientid, sequenceid4 sequenceid) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 43;
        op.opcreate_session = new CREATE_SESSION4args();
        channel_attrs4 chan_attrs = new channel_attrs4();
        chan_attrs.ca_headerpadsize = new count4(new uint32_t(0));
        chan_attrs.ca_maxoperations = new count4(new uint32_t(8192));
        chan_attrs.ca_maxrequests = new count4(new uint32_t(8192));
        chan_attrs.ca_maxrequestsize = new count4(new uint32_t(8192));
        chan_attrs.ca_maxresponsesize = new count4(new uint32_t(8192));
        chan_attrs.ca_maxresponsesize_cached = new count4(new uint32_t(8));
        chan_attrs.ca_rdma_ird = new uint32_t[0];
        op.opcreate_session.csa_clientid = clientid;
        op.opcreate_session.csa_sequence = sequenceid;
        op.opcreate_session.csa_flags = new uint32_t(1);
        op.opcreate_session.csa_fore_chan_attrs = chan_attrs;
        op.opcreate_session.csa_back_chan_attrs = chan_attrs;
        op.opcreate_session.csa_cb_program = new uint32_t(123);
        op.opcreate_session.csa_sec_parms = new callback_sec_parms4[1];
        op.opcreate_session.csa_sec_parms[0] = new callback_sec_parms4();
        op.opcreate_session.csa_sec_parms[0].cb_secflavor = 0;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withSequence(boolean CacheThis, sessionid4 sessionid, int sequence, int slotid, int highSlotid) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 53;
        op.opsequence = new SEQUENCE4args();
        op.opsequence.sa_cachethis = CacheThis;
        slotid4 sId = new slotid4();
        sId.value = new uint32_t(slotid);
        op.opsequence.sa_slotid = sId;
        slotid4 HsId = new slotid4();
        HsId.value = new uint32_t(highSlotid);
        op.opsequence.sa_highest_slotid = HsId;
        sequenceid4 seq = new sequenceid4();
        seq.value = new uint32_t(++sequence);
        op.opsequence.sa_sequenceid = seq;
        op.opsequence.sa_sessionid = sessionid;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withGetattr(int ... attrs) {
        nfs_argop4 op = new nfs_argop4();
        GETATTR4args args = new GETATTR4args();
        args.attr_request = bitmap4.of(attrs);
        op.argop = 9;
        op.opgetattr = args;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withSavefh() {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 32;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withRestorefh() {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 31;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withDestroysession(sessionid4 sessionid) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 44;
        op.opdestroy_session = new DESTROY_SESSION4args();
        op.opdestroy_session.dsa_sessionid = sessionid;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withDestroyclientid(clientid4 clientid) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 57;
        op.opdestroy_clientid = new DESTROY_CLIENTID4args();
        op.opdestroy_clientid.dca_clientid = clientid;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withRemove(String path) {
        REMOVE4args args = new REMOVE4args();
        args.target = new component4();
        args.target.value = new utf8str_cs(path);
        nfs_argop4 op = new nfs_argop4();
        op.argop = 28;
        op.opremove = args;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withWrite(long offset, byte[] data, stateid4 stateid) {
        WRITE4args args = new WRITE4args();
        args.stable = 2;
        args.offset = new offset4(new uint64_t(offset));
        args.stateid = stateid;
        args.data = ByteBuffer.wrap(data);
        args.data.position(data.length);
        nfs_argop4 op = new nfs_argop4();
        op.argop = 38;
        op.opwrite = args;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withRead(int count, long offset, stateid4 stateid) {
        READ4args args = new READ4args();
        args.count = new count4(new uint32_t(count));
        args.offset = new offset4(new uint64_t(offset));
        args.stateid = stateid;
        nfs_argop4 op = new nfs_argop4();
        op.argop = 25;
        op.opread = args;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withGetdevicelist() {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 48;
        op.opgetdevicelist = new GETDEVICELIST4args();
        op.opgetdevicelist.gdla_cookie = new nfs_cookie4();
        op.opgetdevicelist.gdla_cookie.value = new uint64_t(0L);
        op.opgetdevicelist.gdla_cookieverf = new verifier4();
        op.opgetdevicelist.gdla_cookieverf.value = new byte[8];
        op.opgetdevicelist.gdla_layout_type = 1;
        op.opgetdevicelist.gdla_maxdevices = new count4();
        op.opgetdevicelist.gdla_maxdevices.value = new uint32_t(256);
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withGetdeviceinfo(deviceid4 devId) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 47;
        op.opgetdeviceinfo = new GETDEVICEINFO4args();
        op.opgetdeviceinfo.gdia_device_id = devId;
        op.opgetdeviceinfo.gdia_layout_type = 1;
        count4 cn = new count4();
        cn.value = new uint32_t(1024);
        op.opgetdeviceinfo.gdia_maxcount = cn;
        op.opgetdeviceinfo.gdia_notify_types = new bitmap4();
        op.opgetdeviceinfo.gdia_notify_types.value = new uint32_t[1];
        op.opgetdeviceinfo.gdia_notify_types.value[0] = new uint32_t(0);
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withLayoutreturn(long offset, long len, byte[] body, stateid4 stateid) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 51;
        op.oplayoutreturn = new LAYOUTRETURN4args();
        op.oplayoutreturn.lora_reclaim = false;
        op.oplayoutreturn.lora_iomode = 3;
        op.oplayoutreturn.lora_layout_type = 1;
        op.oplayoutreturn.lora_layoutreturn = new layoutreturn4();
        op.oplayoutreturn.lora_layoutreturn.lr_returntype = 1;
        op.oplayoutreturn.lora_layoutreturn.lr_layout = new layoutreturn_file4();
        op.oplayoutreturn.lora_layoutreturn.lr_layout.lrf_offset = new offset4(new uint64_t(offset));
        op.oplayoutreturn.lora_layoutreturn.lr_layout.lrf_length = new length4(new uint64_t(len));
        op.oplayoutreturn.lora_layoutreturn.lr_layout.lrf_body = body;
        op.oplayoutreturn.lora_layoutreturn.lr_layout.lrf_stateid = stateid;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withClose(stateid4 stateid) {
        CLOSE4args args = new CLOSE4args();
        args.seqid = new seqid4(new uint32_t(0));
        args.open_stateid = stateid;
        nfs_argop4 op = new nfs_argop4();
        op.argop = 4;
        op.opclose = args;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withOpenCreate(String path, int sequenceId, clientid4 clientid, int access) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 18;
        op.opopen = new OPEN4args();
        op.opopen.seqid = new seqid4(new uint32_t(sequenceId));
        state_owner4 owner = new state_owner4();
        owner.clientid = clientid;
        owner.owner = "JUnitChimera".getBytes();
        op.opopen.owner = new open_owner4(owner);
        if ((access & 0xFF00) == 0) {
            access |= 0x400;
        }
        op.opopen.share_access = new uint32_t(access);
        op.opopen.share_deny = new uint32_t(0);
        openflag4 flag = new openflag4();
        flag.opentype = 1;
        createhow4 how = new createhow4();
        how.mode = 1;
        fattr4 attr = new fattr4();
        attr.attrmask = CompoundBuilder.openFattrBitmap();
        attr.attr_vals = new attrlist4();
        attr.attr_vals.value = CompoundBuilder.openAttrs();
        how.createattrs = attr;
        how.createverf = new verifier4(new byte[8]);
        how.mode = 1;
        flag.how = how;
        op.opopen.openhow = flag;
        open_claim4 claim = new open_claim4();
        claim.claim = 0;
        claim.file = new component4(new utf8str_cs(path));
        claim.delegate_type = 1024;
        claim.file_delegate_prev = null;
        claim.oc_delegate_stateid = null;
        claim.delegate_type = 0;
        claim.delegate_cur_info = null;
        op.opopen.claim = claim;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withMakedir(String path) {
        CREATE4args args = new CREATE4args();
        args.objname = new component4(new utf8str_cs(path));
        args.objtype = new createtype4();
        args.objtype.type = 2;
        args.createattrs = new fattr4();
        args.createattrs.attr_vals = new attrlist4();
        args.createattrs.attr_vals.value = CompoundBuilder.openAttrs();
        args.createattrs.attrmask = CompoundBuilder.openFattrBitmap();
        nfs_argop4 op = new nfs_argop4();
        op.argop = 6;
        op.opcreate = args;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withOpen(String path, int sequenceId, clientid4 clientid, int access) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 18;
        op.opopen = new OPEN4args();
        op.opopen.seqid = new seqid4(new uint32_t(sequenceId));
        op.opopen.share_access = new uint32_t(1);
        op.opopen.share_deny = new uint32_t(0);
        state_owner4 owner = new state_owner4();
        owner.clientid = clientid;
        owner.owner = "JUnitChimera".getBytes();
        op.opopen.owner = new open_owner4(owner);
        openflag4 flag = new openflag4();
        flag.opentype = 0;
        createhow4 how = new createhow4();
        how.mode = 0;
        flag.how = how;
        op.opopen.openhow = flag;
        open_claim4 claim = new open_claim4();
        claim.claim = 0;
        claim.file = new component4(new utf8str_cs(path));
        claim.delegate_type = 1024;
        claim.file_delegate_prev = null;
        claim.oc_delegate_stateid = null;
        claim.delegate_type = 0;
        claim.delegate_cur_info = null;
        op.opopen.claim = claim;
        this.ops.add(op);
        return this;
    }

    public CompoundBuilder withLayoutget(boolean signal_layout_avail, int layout_type, int iomode, int offset, int length, int minlength, int maxcount, stateid4 stateid) {
        uint64_t u64;
        nfs_argop4 op = new nfs_argop4();
        op.argop = 50;
        op.oplayoutget = new LAYOUTGET4args();
        op.oplayoutget.loga_signal_layout_avail = signal_layout_avail;
        op.oplayoutget.loga_layout_type = layout_type;
        op.oplayoutget.loga_iomode = iomode;
        offset4 off = new offset4();
        off.value = u64 = new uint64_t(offset);
        length4 cnLong = new length4();
        cnLong.value = new uint64_t(length);
        length4 cnZero = new length4();
        cnZero.value = new uint64_t(minlength);
        count4 cnShort = new count4();
        cnShort.value = new uint32_t(maxcount);
        op.oplayoutget.loga_offset = off;
        op.oplayoutget.loga_length = cnLong;
        op.oplayoutget.loga_minlength = cnZero;
        op.oplayoutget.loga_maxcount = cnShort;
        op.oplayoutget.loga_stateid = stateid;
        this.ops.add(op);
        return this;
    }

    public COMPOUND4args build() {
        COMPOUND4args compound4args = new COMPOUND4args();
        compound4args.tag = new utf8str_cs(this.tag);
        compound4args.minorversion = new uint32_t(this.minorversion);
        compound4args.argarray = this.ops.toArray(new nfs_argop4[0]);
        return compound4args;
    }

    private static bitmap4 openFattrBitmap() {
        ArrayList<Integer> attrs = new ArrayList<Integer>();
        attrs.add(4);
        attrs.add(33);
        bitmap4 afttrBitmap = new bitmap4();
        afttrBitmap.value = new uint32_t[2];
        afttrBitmap.value[0] = new uint32_t();
        afttrBitmap.value[1] = new uint32_t();
        for (Integer mask : attrs) {
            uint32_t bitmap;
            int bit;
            if (mask > 31) {
                bit = mask - 32;
                bitmap = afttrBitmap.value[1];
            } else {
                bit = mask;
                bitmap = afttrBitmap.value[0];
            }
            bitmap.value |= 1 << bit;
        }
        return afttrBitmap;
    }

    private static byte[] openAttrs() {
        XdrBuffer xdr = new XdrBuffer(1024);
        try {
            xdr.beginEncoding();
            mode4 fmode = new mode4();
            fmode.value = new uint32_t(493);
            fattr4_mode mode = new fattr4_mode(fmode);
            fattr4_size size = new fattr4_size(new uint64_t(0L));
            size.xdrEncode(xdr);
            mode.xdrEncode(xdr);
        }
        catch (OncRpcException never_happens) {
        }
        catch (IOException never_happens) {
            // empty catch block
        }
        xdr.endEncoding();
        Buffer b = xdr.asBuffer();
        byte[] retBytes = new byte[b.remaining()];
        b.get(retBytes);
        return retBytes;
    }
}

