/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client;

import java.io.IOException;
import java.util.ArrayList;
import org.dcache.chimera.nfs.v4.xdr.OPEN4args;
import org.dcache.chimera.nfs.v4.xdr.attrlist4;
import org.dcache.chimera.nfs.v4.xdr.bitmap4;
import org.dcache.chimera.nfs.v4.xdr.clientid4;
import org.dcache.chimera.nfs.v4.xdr.component4;
import org.dcache.chimera.nfs.v4.xdr.createhow4;
import org.dcache.chimera.nfs.v4.xdr.fattr4;
import org.dcache.chimera.nfs.v4.xdr.fattr4_mode;
import org.dcache.chimera.nfs.v4.xdr.fattr4_size;
import org.dcache.chimera.nfs.v4.xdr.mode4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.open_claim4;
import org.dcache.chimera.nfs.v4.xdr.open_owner4;
import org.dcache.chimera.nfs.v4.xdr.openflag4;
import org.dcache.chimera.nfs.v4.xdr.seqid4;
import org.dcache.chimera.nfs.v4.xdr.state_owner4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cs;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrBuffer;
import org.glassfish.grizzly.Buffer;

public class OpenStub {
    public static nfs_argop4 normalCREATE(String path, int sequenceId, clientid4 clientid, int access) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 18;
        op.opopen = new OPEN4args();
        op.opopen.seqid = new seqid4(new uint32_t(sequenceId));
        state_owner4 owner = new state_owner4();
        owner.clientid = clientid;
        owner.owner = "JUnitChimera".getBytes();
        op.opopen.owner = new open_owner4(owner);
        if ((access & 0xFF00) == 0) {
            access |= 0x400;
        }
        op.opopen.share_access = new uint32_t(access);
        op.opopen.share_deny = new uint32_t(0);
        openflag4 flag = new openflag4();
        flag.opentype = 1;
        createhow4 how = new createhow4();
        how.mode = 1;
        fattr4 attr = new fattr4();
        attr.attrmask = OpenStub.openFattrBitmap();
        attr.attr_vals = new attrlist4();
        attr.attr_vals.value = OpenStub.openAttrs();
        how.createattrs = attr;
        how.createverf = new verifier4(new byte[8]);
        how.mode = 1;
        flag.how = how;
        op.opopen.openhow = flag;
        open_claim4 claim = new open_claim4();
        claim.claim = 0;
        claim.file = new component4(new utf8str_cs(path));
        claim.delegate_type = 1024;
        claim.file_delegate_prev = null;
        claim.oc_delegate_stateid = null;
        claim.delegate_type = 0;
        claim.delegate_cur_info = null;
        op.opopen.claim = claim;
        return op;
    }

    public static nfs_argop4 normalREAD(String path, int sequenceId, clientid4 clientid, int access) {
        nfs_argop4 op = new nfs_argop4();
        op.argop = 18;
        op.opopen = new OPEN4args();
        op.opopen.seqid = new seqid4(new uint32_t(sequenceId));
        op.opopen.share_access = new uint32_t(1);
        op.opopen.share_deny = new uint32_t(0);
        state_owner4 owner = new state_owner4();
        owner.clientid = clientid;
        owner.owner = "JUnitChimera".getBytes();
        op.opopen.owner = new open_owner4(owner);
        openflag4 flag = new openflag4();
        flag.opentype = 0;
        createhow4 how = new createhow4();
        how.mode = 0;
        flag.how = how;
        op.opopen.openhow = flag;
        open_claim4 claim = new open_claim4();
        claim.claim = 0;
        claim.file = new component4(new utf8str_cs(path));
        claim.delegate_type = 1024;
        claim.file_delegate_prev = null;
        claim.oc_delegate_stateid = null;
        claim.delegate_type = 0;
        claim.delegate_cur_info = null;
        op.opopen.claim = claim;
        return op;
    }

    private static bitmap4 openFattrBitmap() {
        ArrayList<Integer> attrs = new ArrayList<Integer>();
        attrs.add(4);
        attrs.add(33);
        bitmap4 afttrBitmap = new bitmap4();
        afttrBitmap.value = new uint32_t[2];
        afttrBitmap.value[0] = new uint32_t();
        afttrBitmap.value[1] = new uint32_t();
        for (Integer mask : attrs) {
            uint32_t bitmap;
            int bit;
            if (mask > 31) {
                bit = mask - 32;
                bitmap = afttrBitmap.value[1];
            } else {
                bit = mask;
                bitmap = afttrBitmap.value[0];
            }
            bitmap.value |= 1 << bit;
        }
        return afttrBitmap;
    }

    private static byte[] openAttrs() {
        XdrBuffer xdr = new XdrBuffer(1024);
        try {
            xdr.beginEncoding();
            mode4 fmode = new mode4();
            fmode.value = new uint32_t(493);
            fattr4_mode mode = new fattr4_mode(fmode);
            fattr4_size size = new fattr4_size(new uint64_t(0L));
            size.xdrEncode(xdr);
            mode.xdrEncode(xdr);
        }
        catch (OncRpcException never_happens) {
        }
        catch (IOException never_happens) {
            // empty catch block
        }
        xdr.endEncoding();
        Buffer b = xdr.asBuffer();
        byte[] retBytes = new byte[b.remaining()];
        b.get(retBytes);
        return retBytes;
    }
}

