/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.dcache.xdr.ReplyQueue;
import org.dcache.xdr.RpcReply;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrTransport;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTransport
implements XdrTransport {
    private static final Logger _log = LoggerFactory.getLogger(ClientTransport.class);
    private final Connection<InetSocketAddress> _connection;
    private final ReplyQueue<Integer, RpcReply> _replyQueue;

    public ClientTransport(Connection<InetSocketAddress> connection, ReplyQueue<Integer, RpcReply> replyQueue) {
        this._replyQueue = replyQueue;
        this._connection = connection;
    }

    @Override
    public void send(Xdr data) throws IOException {
        Buffer buffer = data.asBuffer();
        this._connection.write(buffer);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this._connection.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this._connection.getPeerAddress();
    }

    @Override
    public ReplyQueue<Integer, RpcReply> getReplyQueue() {
        return this._replyQueue;
    }

    @Override
    public XdrTransport getPeerTransport() {
        return null;
    }

    public String toString() {
        return this.getRemoteSocketAddress() + " <=> " + this.getLocalSocketAddress();
    }
}

