/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private static final String CLASS_FILE_SUFFIX = ".class";

    public OverridingClassLoader(ClassLoader parent) {
        super(parent);
        String[] stringArray = DEFAULT_EXCLUDED_PACKAGES;
        int n = DEFAULT_EXCLUDED_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            this.excludePackage(packageName);
            ++n2;
        }
    }

    protected Class loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        Class result = null;
        if (this.isEligibleForOverriding(name2)) {
            result = this.loadClassForOverriding(name2);
        }
        if (result != null) {
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
        return super.loadClass(name2, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        return !this.isExcluded(className);
    }

    protected Class loadClassForOverriding(String name2) throws ClassNotFoundException {
        byte[] bytes;
        Class<?> result = this.findLoadedClass(name2);
        if (result == null && (bytes = this.loadBytesForClass(name2)) != null) {
            result = this.defineClass(name2, bytes, 0, bytes.length);
        }
        return result;
    }

    protected byte[] loadBytesForClass(String name2) throws ClassNotFoundException {
        InputStream is = this.openStreamForClass(name2);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray(is);
            return this.transformIfNecessary(name2, bytes);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name2 + "]", ex);
        }
    }

    protected InputStream openStreamForClass(String name2) {
        String internalName = String.valueOf(name2.replace('.', '/')) + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(internalName);
    }

    protected byte[] transformIfNecessary(String name2, byte[] bytes) {
        return bytes;
    }
}

