/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv.opencsv.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import liquibase.util.csv.opencsv.CSVReader;
import liquibase.util.csv.opencsv.bean.MappingStrategy;

public class HeaderColumnNameMappingStrategy
implements MappingStrategy {
    protected String[] header;
    protected PropertyDescriptor[] descriptors;
    protected Class type;

    public void captureHeader(CSVReader reader) throws IOException {
        this.header = reader.readNext();
    }

    public PropertyDescriptor findDescriptor(int col) throws IntrospectionException {
        String columnName = this.getColumnName(col);
        return null != columnName && columnName.trim().length() > 0 ? this.findDescriptor(columnName) : null;
    }

    protected String getColumnName(int col) {
        return null != this.header && col < this.header.length ? this.header[col] : null;
    }

    protected PropertyDescriptor findDescriptor(String name2) throws IntrospectionException {
        if (null == this.descriptors) {
            this.descriptors = this.loadDescriptors(this.getType());
        }
        for (int i = 0; i < this.descriptors.length; ++i) {
            PropertyDescriptor desc = this.descriptors[i];
            if (!this.matches(name2, desc)) continue;
            return desc;
        }
        return null;
    }

    protected boolean matches(String name2, PropertyDescriptor desc) {
        return desc.getName().equals(name2);
    }

    protected PropertyDescriptor[] loadDescriptors(Class cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        return beanInfo.getPropertyDescriptors();
    }

    public Object createBean() throws InstantiationException, IllegalAccessException {
        return this.type.newInstance();
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }
}

