/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_ID
extends FsInode {
    public FsInode_ID(FileSystemProvider fs, String id) {
        super(fs, id, FsInodeType.ID);
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = null;
        ret = super.stat();
        ret.setSize(this._id.length() + 1);
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        return ret;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        byte[] b = (this._id + "\n").getBytes();
        if (pos > (long)b.length) {
            return 0;
        }
        int copyLen = Math.min(len, b.length - (int)pos);
        System.arraycopy(b, (int)pos, data, 0, copyLen);
        return copyLen;
    }
}

