/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.examples.cli;

import java.util.Date;
import java.util.Formatter;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.examples.cli.FsFactory;
import org.dcache.chimera.posix.Stat;

public class Ls {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            System.err.println("Usage : " + Ls.class.getName() + " " + "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path>");
            System.exit(4);
        }
        FileSystemProvider fs = FsFactory.createFileSystem(args);
        FsInode inode = fs.path2inode(args[5]);
        DirectoryStreamB<HimeraDirectoryEntry> dirStream = inode.newDirectoryStream();
        int count = 0;
        try {
            for (HimeraDirectoryEntry entry : dirStream) {
                Stat stat = entry.getStat();
                Formatter formatter = new Formatter();
                formatter.format("%o %6d %6d %6d %6d %s %s", stat.getMode(), stat.getNlink(), stat.getUid(), stat.getGid(), stat.getSize(), new Date(stat.getMTime()), entry.getName());
                formatter.flush();
                System.out.println(formatter.toString());
                formatter.close();
            }
        }
        finally {
            dirStream.close();
        }
        System.out.println("Total: " + count);
    }
}

