/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPMatcher {
    private static final int IPv4_FULL_MASK = 32;
    private static final int IPv6_FULL_MASK = 128;
    private static final int IPv6_HALF_MASK = 64;

    public static boolean match(String pattern, InetAddress ip) {
        InetAddress[] addresses;
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            String hostName = ip.getHostName();
            return IPMatcher.match(pattern, hostName);
        }
        String[] ipMask = pattern.split("/");
        if (ipMask.length > 2) {
            return false;
        }
        int mask = ipMask.length == 2 ? Integer.parseInt(ipMask[1]) : IPMatcher.fullMaskOf(ip);
        try {
            addresses = InetAddress.getAllByName(ipMask[0]);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        for (InetAddress address : addresses) {
            if (!IPMatcher.match(address, ip, mask)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(String pattern, String hostName) {
        Pattern p = Pattern.compile(IPMatcher.toRegExp(pattern));
        Matcher m = p.matcher(hostName);
        return m.matches();
    }

    public static boolean match(InetAddress ip, InetAddress subnet, int mask) {
        Preconditions.checkArgument(mask >= 0, "Netmask should be positive");
        byte[] ipBytes = ip.getAddress();
        byte[] netBytes = subnet.getAddress();
        if (ipBytes.length != netBytes.length) {
            return false;
        }
        if (ipBytes.length == 4) {
            Preconditions.checkArgument(mask <= 32, "Netmask for ipv4 can't be bigger than32");
            int ipAsInt = Ints.fromByteArray(ipBytes);
            int netAsBytes = Ints.fromByteArray(netBytes);
            return (ipAsInt ^ netAsBytes) >> 32 - mask == 0;
        }
        Preconditions.checkArgument(mask <= 128, "Netmask for ipv6 can't be bigger than128");
        long ipAsLong0 = Longs.fromBytes(ipBytes[0], ipBytes[1], ipBytes[2], ipBytes[3], ipBytes[4], ipBytes[5], ipBytes[6], ipBytes[7]);
        long netAsLong0 = Longs.fromBytes(netBytes[0], netBytes[1], netBytes[2], netBytes[3], netBytes[4], netBytes[5], netBytes[6], netBytes[7]);
        if (mask > 64) {
            long ipAsLong1 = Longs.fromBytes(ipBytes[8], ipBytes[9], ipBytes[10], ipBytes[11], ipBytes[12], ipBytes[13], ipBytes[14], ipBytes[15]);
            long netAsLong1 = Longs.fromBytes(netBytes[8], netBytes[9], netBytes[10], netBytes[11], netBytes[12], netBytes[13], netBytes[14], netBytes[15]);
            return ipAsLong0 == netAsLong0 & (ipAsLong1 ^ netAsLong1) >> 128 - mask == 0L;
        }
        return (ipAsLong0 ^ netAsLong0) >> 64 - mask == 0L;
    }

    private static String toRegExp(String s) {
        return s.replace(".", "\\.").replace("?", ".").replace("*", ".*");
    }

    private static int fullMaskOf(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 32;
        }
        if (address instanceof Inet6Address) {
            return 128;
        }
        throw new IllegalArgumentException("Unsupported Inet type: " + address.getClass().getName());
    }
}

