/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.collect.Sets;
import java.util.Collections;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.Subjects;
import org.dcache.auth.UidPrincipal;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.posix.UnixUser;
import org.dcache.xdr.RpcCall;

public class NfsUser {
    public static final int NOBODY = 65534;
    public static final Subject NFS_NOBODY = new Subject(true, Sets.newHashSet(new UidPrincipal(65534L), new GidPrincipal(65534L, true)), Collections.EMPTY_SET, Collections.EMPTY_SET);

    private NfsUser() {
    }

    public static UnixUser remoteUser(RpcCall call, ExportFile exports2) {
        Subject subject = call.getCredential().getSubject();
        if (subject == Subjects.NOBODY || subject.getPrincipals().isEmpty()) {
            subject = NFS_NOBODY;
        }
        int uid = (int)Subjects.getUid(subject);
        int[] gids = NfsUser.from(Subjects.getGids(subject));
        int gid = gids.length > 0 ? gids[0] : 65534;
        String host = call.getTransport().getRemoteSocketAddress().getAddress().getHostAddress();
        if (!(uid != 0 || exports2 != null && exports2.isTrusted(call.getTransport().getRemoteSocketAddress().getAddress()))) {
            uid = 65534;
            gid = 65534;
        }
        UnixUser user = new UnixUser(uid, gid, gids, host);
        return user;
    }

    private static int[] from(long[] longs) {
        int[] ints = new int[longs.length];
        int i = 0;
        for (long l : longs) {
            ints[i] = (int)l;
            ++i;
        }
        return ints;
    }
}

