/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.vfs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dcache.utils.Bytes;

public class FileHandle {
    private static final int MIN_LEN = 14;
    private static final int VERSION = 1;
    private static final int MAGIC = 13303790;
    private static final byte[] EMPTY_FH = new byte[0];
    private static final byte[] FH_V0_REG = new byte[]{48, 58};
    private static final byte[] FH_V0_PFS = new byte[]{50, 53, 53, 58};
    private final int version;
    private final int magic;
    private final int generation;
    private final int exportIdx;
    private final int type;
    private final byte[] fs_opaque;

    public FileHandle(int generation, int exportIdx, int type, byte[] fs_opaque) {
        this.version = 1;
        this.magic = 13303790;
        this.generation = generation;
        this.exportIdx = exportIdx;
        this.type = type;
        this.fs_opaque = fs_opaque;
    }

    public FileHandle(byte[] bytes) {
        if (bytes.length < 14) {
            throw new IllegalArgumentException("too short");
        }
        ByteBuffer b = ByteBuffer.wrap(bytes);
        b.order(ByteOrder.BIG_ENDIAN);
        int magic_version = b.getInt();
        int geussVersion = (magic_version & 0xFF000000) >>> 24;
        if (geussVersion == 1) {
            this.version = geussVersion;
            this.magic = magic_version & 0xFFFFFF;
            if (this.magic != 13303790) {
                throw new IllegalArgumentException("Bad magic number");
            }
            this.generation = b.getInt();
            this.exportIdx = b.getInt();
            this.type = b.get();
            byte olen = b.get();
            this.fs_opaque = new byte[olen];
            b.get(this.fs_opaque);
        } else if (FileHandle.arrayEquals(bytes, FH_V0_REG, FH_V0_REG.length) || FileHandle.arrayEquals(bytes, FH_V0_PFS, FH_V0_PFS.length)) {
            this.magic = 13303790;
            this.generation = 0;
            int n = this.type = bytes[1] == FH_V0_REG[1] ? 0 : 1;
            if (this.type == 1) {
                this.version = 1;
                this.exportIdx = 0;
                this.fs_opaque = new byte[bytes.length - 2];
                System.arraycopy(bytes, 2, this.fs_opaque, 0, this.fs_opaque.length);
                this.fs_opaque[0] = 48;
            } else {
                this.version = 0;
                this.exportIdx = -1;
                this.fs_opaque = bytes;
            }
        } else {
            throw new IllegalArgumentException("Unsupported version: " + geussVersion);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getExportIdx() {
        return this.exportIdx;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getFsOpaque() {
        return this.fs_opaque;
    }

    public byte[] bytes() {
        int len = this.fs_opaque.length + 14;
        byte[] bytes = new byte[len];
        ByteBuffer b = ByteBuffer.wrap(bytes);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putInt(this.version << 24 | this.magic);
        b.putInt(this.generation);
        b.putInt(this.exportIdx);
        b.put((byte)this.type);
        b.put((byte)this.fs_opaque.length);
        b.put(this.fs_opaque);
        return bytes;
    }

    public String toString() {
        return Bytes.toHexString(this.bytes());
    }

    private static boolean arrayEquals(byte[] a1, byte[] a2, int len) {
        if (a1.length < len || a2.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ byte[] access$000() {
        return EMPTY_FH;
    }

    public static class FileHandleBuilder {
        private int version = 1;
        private int magic = 13303790;
        private int generation = 0;
        private int export_idx = 0;
        private int type = 0;
        private byte[] fs_opaque = FileHandle.access$000();

        public FileHandleBuilder setGeneration(int generation) {
            this.generation = generation;
            return this;
        }

        public FileHandleBuilder setExportIdx(int export_idx) {
            this.export_idx = export_idx;
            return this;
        }

        public FileHandleBuilder setType(int type) {
            this.type = type;
            return this;
        }

        public FileHandleBuilder setFsOpaque(byte[] fs_opaque) {
            this.fs_opaque = fs_opaque;
            return this;
        }

        public FileHandle build(byte[] opaque) {
            return new FileHandle(this.generation, this.export_idx, this.type, opaque);
        }

        public FileHandle build() {
            return this.build(this.fs_opaque);
        }
    }
}

