/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.vfs;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.dcache.chimera.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsCache {
    private static final Logger _log = LoggerFactory.getLogger(FsCache.class);
    private LoadingCache<Inode, FileChannel> _cache;
    private int _maxSize;
    private int _lastAccess;
    private File _base;

    public void setBase(File base) {
        this._base = base;
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public void setLastAccess(int timeInSec) {
        this._lastAccess = timeInSec;
    }

    public void init() {
        this._cache = CacheBuilder.newBuilder().maximumSize(this._maxSize).expireAfterAccess(this._lastAccess, TimeUnit.SECONDS).removalListener(new InodeGarbageCollector()).build(new FileChannelSupplier(this._base));
    }

    public FileChannel get(Inode inode) {
        return this._cache.getUnchecked(inode);
    }

    private static class InodeGarbageCollector
    implements RemovalListener<Inode, FileChannel> {
        private InodeGarbageCollector() {
        }

        @Override
        public void onRemoval(RemovalNotification<Inode, FileChannel> notification) {
            try {
                notification.getValue().close();
            }
            catch (IOException e) {
                _log.error("Failed to close file channel of {} : {}", notification.getKey(), (Object)e.getMessage());
            }
        }
    }

    private static class FileChannelSupplier
    extends CacheLoader<Inode, FileChannel> {
        private final File _base;

        FileChannelSupplier(File base) {
            if (!base.isDirectory()) {
                throw new IllegalArgumentException(base + " : not exist or not a directory");
            }
            this._base = base;
        }

        @Override
        public FileChannel load(Inode inode) throws IOException {
            byte[] fid = inode.getFileId();
            String id = new String(fid);
            File dir = this.getAndCreateDirectory(id);
            File f = new File(dir, id);
            return new RandomAccessFile(f, "rw").getChannel();
        }

        private File getAndCreateDirectory(String id) {
            int len = id.length();
            String topLevelDir = id.substring(len - 6, len - 4);
            String subDir = id.substring(len - 4, len - 2);
            File dir = new File(this._base, topLevelDir + "/" + subDir);
            dir.mkdirs();
            return dir;
        }
    }
}

