/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.posix;

import java.sql.Date;
import java.sql.Time;
import java.util.Formatter;
import org.dcache.chimera.UnixPermission;

public class Stat {
    private int _dev = 0;
    private int _ino = 0;
    private int _mode = 0;
    private int _nlink = 0;
    private int _uid = 0;
    private int _gid = 0;
    private int _rdev = 0;
    private long _size = 0L;
    private long _atime = 0L;
    private long _mtime = 0L;
    private long _ctime = 0L;
    private int _blksize = 512;

    public void setDev(int newDev) {
        this._dev = newDev;
    }

    public int getDev() {
        return this._dev;
    }

    public void setIno(int newIno) {
        this._ino = newIno;
    }

    public int getIno() {
        return this._ino;
    }

    public void setMode(int newMode) {
        this._mode = newMode;
    }

    public int getMode() {
        return this._mode;
    }

    public void setNlink(int newNlink) {
        this._nlink = newNlink;
    }

    public int getNlink() {
        return this._nlink;
    }

    public void setUid(int newUid) {
        this._uid = newUid;
    }

    public int getUid() {
        return this._uid;
    }

    public void setGid(int newGid) {
        this._gid = newGid;
    }

    public int getGid() {
        return this._gid;
    }

    public void setRdev(int newRdev) {
        this._rdev = newRdev;
    }

    public int getRdev() {
        return this._rdev;
    }

    public void setSize(long newSize) {
        this._size = newSize;
    }

    public long getSize() {
        return this._size;
    }

    public void setCTime(long newCTime) {
        this._ctime = newCTime;
    }

    public long getCTime() {
        return this._ctime;
    }

    public void setATime(long newATime) {
        this._atime = newATime;
    }

    public long getATime() {
        return this._atime;
    }

    public void setMTime(long newMTime) {
        this._mtime = newMTime;
    }

    public long getMTime() {
        return this._mtime;
    }

    public void setBlkSize(int newBlkSize) {
        this._blksize = newBlkSize;
    }

    public int getBlkSize() {
        return this._blksize;
    }

    public long getBlocks() {
        return (this._size + (long)this._blksize - 1L) / (long)this._blksize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%s %8d %6d %6d %6d %s %s", new UnixPermission(this.getMode()), this.getNlink(), this.getUid(), this.getGid(), this.getSize(), new Date(this.getMTime()), new Time(this.getMTime()));
        formatter.flush();
        formatter.close();
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + this._dev;
        hash = 79 * hash + this._ino;
        hash = 79 * hash + this._mode;
        hash = 79 * hash + this._nlink;
        hash = 79 * hash + this._uid;
        hash = 79 * hash + this._gid;
        hash = 79 * hash + this._rdev;
        hash = 79 * hash + (int)(this._size ^ this._size >>> 32);
        hash = 79 * hash + (int)(this._atime ^ this._atime >>> 32);
        hash = 79 * hash + (int)(this._mtime ^ this._mtime >>> 32);
        hash = 79 * hash + (int)(this._ctime ^ this._ctime >>> 32);
        hash = 79 * hash + this._blksize;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stat other = (Stat)obj;
        if (this._dev != other._dev) {
            return false;
        }
        if (this._ino != other._ino) {
            return false;
        }
        if (this._mode != other._mode) {
            return false;
        }
        if (this._nlink != other._nlink) {
            return false;
        }
        if (this._uid != other._uid) {
            return false;
        }
        if (this._gid != other._gid) {
            return false;
        }
        if (this._rdev != other._rdev) {
            return false;
        }
        if (this._size != other._size) {
            return false;
        }
        if (this._atime != other._atime) {
            return false;
        }
        if (this._mtime != other._mtime) {
            return false;
        }
        if (this._ctime != other._ctime) {
            return false;
        }
        return this._blksize == other._blksize;
    }

    public static void main(String[] args) {
        Stat stat = new Stat();
        stat.setMTime(System.currentTimeMillis());
        System.out.println(stat);
    }
}

