/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import org.dcache.xdr.MismatchInfo;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcAccepsStatus;
import org.dcache.xdr.RpcAuthStat;
import org.dcache.xdr.RpcAuthVerifier;
import org.dcache.xdr.RpcRejectStatus;
import org.dcache.xdr.RpcReplyStatus;
import org.dcache.xdr.Xdr;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcReply {
    private static final Logger _log = LoggerFactory.getLogger(RpcReply.class);
    private final int _xid;
    private final Xdr _xdr;
    private int _replyStatus;
    private int _acceptedStatus;
    private int _rejectStatus;
    private MismatchInfo _mismatchInfo;
    private int _authStatus;
    private RpcAuthVerifier _verf;
    private final XdrTransport _transport;

    public RpcReply(int xid, Xdr xdr, XdrTransport transport) throws OncRpcException, IOException {
        this._xid = xid;
        this._xdr = xdr;
        this._transport = transport;
        this._replyStatus = xdr.xdrDecodeInt();
        switch (this._replyStatus) {
            case 0: {
                this._verf = new RpcAuthVerifier(xdr);
                this._acceptedStatus = xdr.xdrDecodeInt();
                switch (this._acceptedStatus) {
                    case 2: {
                        this._mismatchInfo = new MismatchInfo();
                        this._mismatchInfo.xdrDecode(xdr);
                    }
                }
                break;
            }
            case 1: {
                this._rejectStatus = xdr.xdrDecodeInt();
                switch (this._rejectStatus) {
                    case 0: {
                        this._mismatchInfo = new MismatchInfo();
                        this._mismatchInfo.xdrDecode(xdr);
                        break;
                    }
                    case 1: {
                        this._authStatus = xdr.xdrDecodeInt();
                    }
                }
                break;
            }
        }
    }

    public boolean isAccepted() {
        return this._replyStatus == 0;
    }

    public int getAcceptStatus() {
        if (!this.isAccepted()) {
            throw new IllegalStateException("Message in not accepted");
        }
        return this._acceptedStatus;
    }

    public MismatchInfo getMismatchInfo() {
        return this._mismatchInfo;
    }

    public int getAuthStatus() {
        return this._authStatus;
    }

    public int getRejectStatus() {
        if (this.isAccepted()) {
            throw new IllegalStateException("Message is accepted");
        }
        return this._rejectStatus;
    }

    public void getReplyResult(XdrAble result) throws OncRpcException, IOException {
        result.xdrDecode(this._xdr);
        this._xdr.endEncoding();
    }

    public void reply(XdrAble reply) throws OncRpcException, IOException {
        this._xdr.beginEncoding();
        this._xdr.xdrEncodeInt(this._xid);
        this._xdr.xdrEncodeInt(1);
        this._xdr.xdrEncodeInt(this._replyStatus);
        this._verf.xdrEncode(this._xdr);
        reply.xdrEncode(this._xdr);
        this._xdr.endEncoding();
        this._transport.send(this._xdr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("xid: ").append(this._xid);
        sb.append(" Status: ").append(RpcReplyStatus.toString(this._replyStatus));
        if (this._replyStatus == 0) {
            sb.append(" AccespStatus: ").append(RpcAccepsStatus.toString(this._acceptedStatus));
            if (this._acceptedStatus == 2) {
                sb.append(" :").append(this._mismatchInfo);
            }
        } else {
            sb.append(" RejectStatus: ").append(RpcRejectStatus.toString(this._rejectStatus));
            if (this._rejectStatus == 1) {
                sb.append(" AuthError: ").append(RpcAuthStat.toString(this._authStatus));
            }
        }
        return sb.toString();
    }
}

