/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.gss;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.utils.Opaque;
import org.dcache.xdr.RpcLoginService;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GssSessionManager {
    private static final Logger _log = LoggerFactory.getLogger(GssSessionManager.class);
    private final GSSManager gManager = GSSManager.getInstance();
    private final GSSCredential _serviceCredential;
    private final RpcLoginService _loginService;
    private final Map<Opaque, GSSContext> sessions = new ConcurrentHashMap<Opaque, GSSContext>();

    public GssSessionManager(RpcLoginService loginService) throws GSSException {
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
        this._serviceCredential = this.gManager.createCredential(null, Integer.MAX_VALUE, krb5Mechanism, 2);
        this._loginService = loginService;
    }

    public GSSContext createContext(byte[] handle) throws GSSException {
        GSSContext context = this.gManager.createContext(this._serviceCredential);
        this.sessions.put(new Opaque(handle), context);
        return context;
    }

    public GSSContext getContext(byte[] handle) throws GSSException {
        GSSContext context = this.sessions.get(new Opaque(handle));
        if (context == null) {
            throw new GSSException(12);
        }
        return context;
    }

    public GSSContext getEstablishedContext(byte[] handle) throws GSSException {
        GSSContext context = this.getContext(handle);
        if (!context.isEstablished()) {
            throw new GSSException(12);
        }
        return context;
    }

    public GSSContext destroyContext(byte[] handle) throws GSSException {
        GSSContext context = this.sessions.remove(new Opaque(handle));
        if (context == null || !context.isEstablished()) {
            throw new GSSException(12);
        }
        return context;
    }

    public Subject subjectOf(GSSName name2) {
        return this._loginService.login(new KerberosPrincipal(name2.toString()));
    }
}

