/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.portmap;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.XdrBoolean;
import org.dcache.xdr.XdrVoid;
import org.dcache.xdr.portmap.Port;
import org.dcache.xdr.portmap.mapping;
import org.dcache.xdr.portmap.pmaplist;
import org.dcache.xdr.portmap.rpcb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OncRpcbindServer
implements RpcDispatchable {
    private static final Logger _log = LoggerFactory.getLogger(OncRpcbindServer.class);
    private final Set<rpcb> _services = new HashSet<rpcb>();

    public OncRpcbindServer() {
        this._services.add(new rpcb(100000, 2, "tcp", "0.0.0.0.0.111", "superuser"));
        this._services.add(new rpcb(100000, 2, "udp", "0.0.0.0.0.111", "superuser"));
    }

    @Override
    public void dispatchOncRpcCall(RpcCall call) throws OncRpcException, IOException {
        int version = call.getProgramVersion();
        switch (version) {
            case 2: {
                this.processV2Call(call);
                break;
            }
            default: {
                call.failProgramMismatch(2, 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processV2Call(RpcCall call) throws OncRpcException, IOException {
        switch (call.getProcedure()) {
            case 0: {
                call.reply(XdrVoid.XDR_VOID);
                break;
            }
            case 1: {
                mapping newMapping = new mapping();
                call.retrieveCall(newMapping);
                rpcb rpcbMapping = new rpcb(newMapping);
                Set<rpcb> set = this._services;
                synchronized (set) {
                    this._services.add(rpcbMapping);
                }
                call.reply(XdrBoolean.True);
                break;
            }
            case 4: {
                pmaplist list;
                pmaplist next = list = new pmaplist();
                Set<rpcb> set = this._services;
                synchronized (set) {
                    for (rpcb mapping2 : this._services) {
                        next.setEntry(mapping2.toMapping());
                        pmaplist n = new pmaplist();
                        next.setNext(n);
                        next = n;
                    }
                }
                call.reply(list);
                break;
            }
            case 3: {
                mapping query = new mapping();
                call.retrieveCall(query);
                rpcb result = this.search(new rpcb(query));
                Port port = result == null ? new Port(0) : new Port(result.toMapping().getPort());
                call.reply(port);
                break;
            }
            default: {
                call.failProcedureUnavailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private rpcb search(rpcb query) {
        Set<rpcb> set = this._services;
        synchronized (set) {
            for (rpcb e : this._services) {
                if (!e.match(query)) continue;
                return e;
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 1) {
            System.err.println("Usage: SimpleRpcServer <port>");
            System.exit(1);
        }
        int port = 111;
        if (args.length == 1) {
            port = Integer.parseInt(args[0]);
        }
        OncRpcbindServer rpcbind = new OncRpcbindServer();
        OncRpcSvc server = new OncRpcSvc(port);
        server.register(new OncRpcProgram(100000, 2), rpcbind);
        server.start();
    }
}

