/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.glassfish.gmbal.generic.Algorithms;
import org.glassfish.gmbal.generic.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationTracer {
    private static boolean enabled = true;
    private static ThreadLocal<List<Pair<String, Object[]>>> state = new ThreadLocal(){

        public List<Pair<String, Object[]>> initialValue() {
            return new ArrayList<Pair<String, Object[]>>();
        }
    };

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    private OperationTracer() {
    }

    private static String format(Pair<String, Object[]> arg) {
        String name2 = arg.first();
        Object[] args = arg.second();
        StringBuilder sb = new StringBuilder();
        if (name2 == null) {
            sb.append("!NULL_NAME!");
        } else {
            sb.append(name2);
        }
        sb.append('(');
        boolean first = true;
        for (Object obj : args) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(Algorithms.convertToString(obj));
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getAsString() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        List<Pair<String, Object[]>> elements = state.get();
        int ctr = 0;
        for (Pair<String, Object[]> elem : elements) {
            fmt.format("\n\t(%3d): %s", ctr++, OperationTracer.format(elem));
        }
        return sb.toString();
    }

    public static void clear() {
        if (enabled) {
            state.get().clear();
        }
    }

    public static void enter(String name2, Object ... args) {
        if (enabled) {
            state.get().add(new Pair<String, Object[]>(name2, args));
        }
    }

    public static void exit() {
        List<Pair<String, Object[]>> elements;
        int size;
        if (enabled && (size = (elements = state.get()).size()) > 0) {
            elements.remove(size - 1);
        }
    }
}

