/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class TimestampAction
extends Action {
    static String DATE_PATTERN_ATTRIBUTE = "datePattern";
    static String TIME_REFERENCE_ATTRIBUTE = "timeReference";
    static String CONTEXT_BIRTH = "contextBirth";
    boolean inError = false;

    public void begin(InterpretationContext ec, String name2, Attributes attributes) throws ActionException {
        String datePatternStr;
        String keyStr = attributes.getValue("key");
        if (OptionHelper.isEmpty(keyStr)) {
            this.addError("Attribute named [key] cannot be empty");
            this.inError = true;
        }
        if (OptionHelper.isEmpty(datePatternStr = attributes.getValue(DATE_PATTERN_ATTRIBUTE))) {
            this.addError("Attribute named [" + DATE_PATTERN_ATTRIBUTE + "] cannot be empty");
            this.inError = true;
        }
        String timeReferenceStr = attributes.getValue(TIME_REFERENCE_ATTRIBUTE);
        long timeReference = -1L;
        if (CONTEXT_BIRTH.equalsIgnoreCase(timeReferenceStr)) {
            this.addInfo("Using context birth as time reference.");
            timeReference = this.context.getBirthTime();
        } else {
            timeReference = System.currentTimeMillis();
            this.addInfo("Using current interpretation time, i.e. now, as time reference.");
        }
        if (this.inError) {
            return;
        }
        CachingDateFormatter sdf = new CachingDateFormatter(datePatternStr);
        String val = sdf.format(timeReference);
        this.addInfo("Adding property to the context with key=\"" + keyStr + "\" and value=\"" + val + "\" to the context");
        this.context.putProperty(keyStr, val);
    }

    public void end(InterpretationContext ec, String name2) throws ActionException {
    }
}

