/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition;

import java.util.HashMap;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.precondition.Precondition;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreconditionFactory {
    private final Map<String, Class<? extends Precondition>> preconditions = new HashMap<String, Class<? extends Precondition>>();
    private static PreconditionFactory instance;

    private PreconditionFactory() {
        try {
            Class[] classes;
            for (Class clazz : classes = ServiceLocator.getInstance().findClasses(Precondition.class)) {
                this.register(clazz);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static PreconditionFactory getInstance() {
        if (instance == null) {
            instance = new PreconditionFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new PreconditionFactory();
    }

    public Map<String, Class<? extends Precondition>> getPreconditions() {
        return this.preconditions;
    }

    public void register(Class<? extends Precondition> clazz) {
        try {
            this.preconditions.put(clazz.newInstance().getName(), clazz);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public void unregister(String name2) {
        this.preconditions.remove(name2);
    }

    public Precondition create(String tagName) {
        Class<? extends Precondition> aClass = this.preconditions.get(tagName);
        if (aClass == null) {
            throw new UnexpectedLiquibaseException("Unknown tag: " + tagName);
        }
        try {
            return aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

