/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.SetTableRemarksStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTableRemarksGenerator
extends AbstractSqlGenerator<SetTableRemarksStatement> {
    @Override
    public boolean supports(SetTableRemarksStatement statement, Database database) {
        return database instanceof MySQLDatabase || database instanceof OracleDatabase || database instanceof PostgresDatabase;
    }

    @Override
    public ValidationErrors validate(SetTableRemarksStatement setTableRemarksStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", setTableRemarksStatement.getTableName());
        validationErrors.checkRequiredField("remarks", setTableRemarksStatement.getRemarks());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(SetTableRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String remarks = database.escapeStringForDatabase(statement.getRemarks());
        String sql = database instanceof MySQLDatabase ? "ALTER TABLE " + database.escapeTableName(statement.getSchemaName(), statement.getTableName()) + " COMMENT = '" + remarks + "'" : "COMMENT ON TABLE " + database.escapeTableName(statement.getSchemaName(), statement.getTableName()) + " IS '" + remarks + "'";
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

