/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.Who;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.DirectoryStreamImpl;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.InvalidNameChimeraException;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.chimera.StorageGenericLocation;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.UnixPermission;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.AccessLatency;
import org.dcache.chimera.store.InodeStorageInformation;
import org.dcache.chimera.store.RetentionPolicy;
import org.dcache.chimera.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FsSqlDriver {
    private static final Logger _log = LoggerFactory.getLogger(FsSqlDriver.class);
    private static final int IOMODE_ENABLE = 1;
    private static final int IOMODE_DISABLE = 0;
    private final int _ioMode = Boolean.valueOf(System.getProperty("chimera.inodeIoMode")) != false ? 1 : 0;
    private static final String sqlUsedSpace = "SELECT SUM(isize) AS usedSpace FROM t_inodes WHERE itype=32768";
    private static final String sqlUsedFiles = "SELECT count(ipnfsid) AS usedFiles FROM t_inodes WHERE itype=32768";
    private static final String sqlListDir = "SELECT * FROM t_dirs WHERE iparent=?";
    private static final String sqlListDirFull = "SELECT t_inodes.ipnfsid, t_dirs.iname, t_inodes.isize,t_inodes.inlink,t_inodes.imode,t_inodes.itype,t_inodes.iuid,t_inodes.igid,t_inodes.iatime,t_inodes.ictime,t_inodes.imtime  FROM t_inodes, t_dirs WHERE iparent=? AND t_inodes.ipnfsid = t_dirs.ipnfsid";
    private static final String sqlStat = "SELECT isize,inlink,itype,imode,iuid,igid,iatime,ictime,imtime,icrtime FROM t_inodes WHERE ipnfsid=?";
    private static final String sqlMove = "UPDATE t_dirs SET iparent=?, iname=? WHERE iparent=? AND iname=?";
    private static final String sqlSetParent = "UPDATE t_dirs SET ipnfsid=? WHERE iparent=? AND iname='..'";
    private static final String sqlInodeOf = "SELECT ipnfsid FROM t_dirs WHERE iname=? AND iparent=?";
    private static final String sqlInode2Path_name = "SELECT iname FROM t_dirs WHERE ipnfsid=? AND iparent=? and iname !='.' and iname != '..'";
    private static final String sqlInode2Path_inode = "SELECT iparent FROM t_dirs WHERE ipnfsid=?  and iname != '.' and iname != '..'";
    private static final String sqlCreateInode = "INSERT INTO t_inodes VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String sqlRemoveInode = "DELETE FROM t_inodes WHERE ipnfsid=? AND inlink = 0";
    private static final String sqlIncNlink = "UPDATE t_inodes SET inlink=inlink +?,imtime=?,ictime=? WHERE ipnfsid=?";
    private static final String sqlDecNlink = "UPDATE t_inodes SET inlink=inlink -?,imtime=?,ictime=? WHERE ipnfsid=?";
    private static final String sqlCreateEntryInParent = "INSERT INTO t_dirs VALUES(?,?,?)";
    private static final String sqlRemoveEntryInParentByID = "DELETE FROM t_dirs WHERE ipnfsid=? AND iparent=?";
    private static final String sqlRemoveEntryInParentByName = "DELETE FROM t_dirs WHERE iname=? AND iparent=?";
    private static final String sqlGetParentOf = "SELECT iparent FROM t_dirs WHERE ipnfsid=? AND iname != '.' and iname != '..'";
    private static final String sqlGetParentOfDirectory = "SELECT iparent FROM t_dirs WHERE ipnfsid=? AND iname!='..' AND iname !='.'";
    private static final String sqlGetNameOf = "SELECT iname FROM t_dirs WHERE ipnfsid=? AND iparent=?";
    private static final String sqlSetFileSize = "UPDATE t_inodes SET isize=?,imtime=?,ictime=? WHERE ipnfsid=?";
    private static final String sqlSetFileOwner = "UPDATE t_inodes SET iuid=?,ictime=? WHERE ipnfsid=?";
    private static final String sqlSetFileName = "UPDATE t_dirs SET iname=? WHERE iname=? AND iparent=?";
    private static final String sqlSetInodeAttributes = "UPDATE t_inodes SET iatime=?, imtime=?, ictime=?, isize=?, iuid=?, igid=?, imode=?, itype=? WHERE ipnfsid=?";
    private static final String sqlSetFileATime = "UPDATE t_inodes SET iatime=? WHERE ipnfsid=?";
    private static final String sqlSetFileCTime = "UPDATE t_inodes SET ictime=? WHERE ipnfsid=?";
    private static final String sqlSetFileMTime = "UPDATE t_inodes SET imtime=? WHERE ipnfsid=?";
    private static final String sqlSetFileGroup = "UPDATE t_inodes SET igid=?,ictime=? WHERE ipnfsid=?";
    private static final String sqlSetFileMode = "UPDATE t_inodes SET imode=?,ictime=? WHERE ipnfsid=?";
    private static final String sqlIsIoEnabled = "SELECT iio FROM t_inodes WHERE ipnfsid=?";
    private static final String sqlSetInodeIo = "UPDATE t_inodes SET iio=? WHERE ipnfsid=?";
    private static final String sqlGetInodeLocations = "SELECT ilocation,ipriority,ictime,iatime  FROM t_locationinfo WHERE itype=? AND ipnfsid=? AND istate=1 ORDER BY ipriority DESC";
    private static final String sqlAddInodeLocation = "INSERT INTO t_locationinfo VALUES(?,?,?,?,?,?,?)";
    private static final String sqlClearInodeLocation = "DELETE FROM t_locationinfo WHERE ipnfsid=? AND itype=? AND ilocation=?";
    private static final String sqlClearInodeLocations = "DELETE FROM t_locationinfo WHERE ipnfsid=?";
    private static final String sqlTags = "SELECT itagname FROM t_tags where ipnfsid=?";
    private static final String sqlGetTagId = "SELECT itagid FROM t_tags WHERE ipnfsid=? AND itagname=?";
    private static final String sqlCreateTagInode = "INSERT INTO t_tags_inodes VALUES(?,?,1,?,?,0,?,?,?,NULL)";
    private static final String sqlAssignTagToDir_update = "UPDATE t_tags SET itagid=?,isorign=? WHERE ipnfsid=? AND itagname=?";
    private static final String sqlAssignTagToDir_add = "INSERT INTO t_tags VALUES(?,?,?,1)";
    private static final String sqlSetTag = "UPDATE t_tags_inodes SET ivalue=?, isize=?, imtime=? WHERE itagid=?";
    private static final String sqlRemoveTag = "DELETE FROM t_tags WHERE ipnfsid=?";
    private static final String sqlGetTag = "SELECT ivalue,isize FROM t_tags_inodes WHERE itagid=?";
    private static final String sqlStatTag = "SELECT isize,inlink,imode,iuid,igid,iatime,ictime,imtime FROM t_tags_inodes WHERE itagid=?";
    private static final String sqlIsTagOwner = "SELECT isorign FROM t_tags WHERE ipnfsid=? AND itagname=?";
    private static final String sqlCopyTag = "INSERT INTO t_tags ( SELECT ?, itagname, itagid, 0 from t_tags WHERE ipnfsid=?)";
    private static final String sqlSetTagOwner = "UPDATE t_tags_inodes SET iuid=?, ictime=? WHERE itagid=?";
    private static final String sqlSetTagOwnerGroup = "UPDATE t_tags_inodes SET igid=?, ictime=? WHERE itagid=?";
    private static final String sqlSetTagMode = "UPDATE t_tags_inodes SET imode=?, ictime=? WHERE itagid=?";
    private static final String sqlSetStorageInfo = "INSERT INTO t_storageinfo VALUES(?,?,?,?)";
    private static final String sqlGetAccessLatency = "SELECT iaccessLatency FROM t_access_latency WHERE ipnfsid=?";
    private static final String sqlGetRetentionPolicy = "SELECT iretentionPolicy FROM t_retention_policy WHERE ipnfsid=?";
    private static final String sqlSetAccessLatency = "INSERT INTO t_access_latency VALUES(?,?)";
    private static final String sqlUpdateAccessLatency = "UPDATE t_access_latency SET iaccessLatency=? WHERE ipnfsid=?";
    private static final String sqlSetRetentionPolicy = "INSERT INTO t_retention_policy VALUES(?,?)";
    private static final String sqlUpdateRetentionPolicy = "UPDATE t_retention_policy SET iretentionPolicy=? WHERE ipnfsid=?";
    private static final String sqlRemoveStorageInfo = "DELETE FROM t_storageinfo WHERE ipnfsid=?";
    private static final String sqlGetStorageInfo = "SELECT ihsmName, istorageGroup, istorageSubGroup, iaccessLatency, iretentionPolicy FROM t_storageinfo,t_access_latency,t_retention_policy WHERE t_storageinfo.ipnfsid=t_access_latency.ipnfsid AND t_storageinfo.ipnfsid=t_retention_policy.ipnfsid AND t_storageinfo.ipnfsid=?";
    private static final String sqlGetInodeFromCache = "SELECT ipnfsid FROM t_dir_cache WHERE ipath=?";
    private static final String sqlGetPathFromCache = "SELECT ipath FROM t_dir_cache WHERE ipnfsid=?";
    private static final String sqlSetInodeChecksum = "INSERT INTO t_inodes_checksum VALUES(?,?,?)";
    private static final String sqlGetInodeChecksum = "SELECT isum FROM t_inodes_checksum WHERE ipnfsid=? AND itype=?";
    private static final String sqlRemoveInodeChecksum = "DELETE FROM t_inodes_checksum WHERE ipnfsid=? AND itype=?";
    private static final String sqlRemoveInodeAllChecksum = "DELETE FROM t_inodes_checksum WHERE ipnfsid=?";
    private static final String sqlGetACL = "SELECT * FROM t_acl WHERE rs_id =  ? ORDER BY ace_order";
    private static final String sqlDeleteACL = "DELETE FROM t_acl WHERE rs_id = ?";
    private static final String sqlAddACL = "INSERT INTO t_acl VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

    protected FsSqlDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long usedSpace(Connection dbConnection) throws SQLException {
        long usedSpace = 0L;
        PreparedStatement stUsedSpace = null;
        ResultSet rs = null;
        try {
            stUsedSpace = dbConnection.prepareStatement(sqlUsedSpace);
            rs = stUsedSpace.executeQuery();
            if (rs.next()) {
                usedSpace = rs.getLong("usedSpace");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stUsedSpace);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stUsedSpace);
        return usedSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long usedFiles(Connection dbConnection) throws SQLException {
        long usedFiles = 0L;
        PreparedStatement stUsedFiles = null;
        ResultSet rs = null;
        try {
            stUsedFiles = dbConnection.prepareStatement(sqlUsedFiles);
            rs = stUsedFiles.executeQuery();
            if (rs.next()) {
                usedFiles = rs.getLong("usedFiles");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stUsedFiles);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stUsedFiles);
        return usedFiles;
    }

    FsInode createFile(Connection dbConnection, FsInode parent, String name2, int owner, int group, int mode, int type) throws ChimeraFsException, SQLException {
        FsInode inode = null;
        inode = new FsInode(parent.getFs());
        this.createFileWithId(dbConnection, parent, inode, name2, owner, group, mode, type);
        return inode;
    }

    FsInode createFileWithId(Connection dbConnection, FsInode parent, FsInode inode, String name2, int owner, int group, int mode, int type) throws ChimeraFsException, SQLException {
        this.createInode(dbConnection, inode, type, owner, group, mode, 1);
        this.createEntryInParent(dbConnection, parent, name2, inode);
        this.incNlink(dbConnection, parent);
        this.setFileMTime(dbConnection, parent, 0, System.currentTimeMillis());
        return inode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] listDir(Connection dbConnection, FsInode dir) throws SQLException {
        String[] list = null;
        ResultSet result = null;
        PreparedStatement stListDirectory = null;
        try {
            stListDirectory = dbConnection.prepareStatement(sqlListDir);
            stListDirectory.setString(1, dir.toString());
            stListDirectory.setFetchSize(1000);
            result = stListDirectory.executeQuery();
            ArrayList<String> directoryList = new ArrayList<String>();
            while (result.next()) {
                directoryList.add(result.getString("iname"));
            }
            list = directoryList.toArray(new String[directoryList.size()]);
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose(stListDirectory);
            throw throwable;
        }
        SqlHelper.tryToClose(result);
        SqlHelper.tryToClose(stListDirectory);
        return list;
    }

    DirectoryStreamB<HimeraDirectoryEntry> newDirectoryStream(Connection dbConnection, FsInode dir) throws SQLException {
        ResultSet result = null;
        PreparedStatement stListDirectoryFull = null;
        stListDirectoryFull = dbConnection.prepareStatement(sqlListDirFull);
        stListDirectoryFull.setFetchSize(50);
        stListDirectoryFull.setString(1, dir.toString());
        result = stListDirectoryFull.executeQuery();
        return new DirectoryStreamImpl(dir, dbConnection, stListDirectoryFull, result);
    }

    boolean remove(Connection dbConnection, FsInode parent, String name2) throws ChimeraFsException, SQLException {
        FsInode inode = this.inodeOf(dbConnection, parent, name2);
        if (inode.isDirectory()) {
            return this.removeDir(dbConnection, parent, inode, name2);
        }
        return this.removeFile(dbConnection, parent, inode, name2);
    }

    private boolean removeDir(Connection dbConnection, FsInode parent, FsInode inode, String name2) throws ChimeraFsException, SQLException {
        Stat dirStat = inode.statCache();
        if (dirStat.getNlink() > 2) {
            throw new ChimeraFsException("directory is not empty");
        }
        this.removeEntryInParent(dbConnection, inode, ".");
        this.removeEntryInParent(dbConnection, inode, "..");
        this.decNlink(dbConnection, inode, 2);
        this.removeTag(dbConnection, inode);
        this.removeEntryInParent(dbConnection, parent, name2);
        this.decNlink(dbConnection, parent);
        this.setFileMTime(dbConnection, parent, 0, System.currentTimeMillis());
        return this.removeInode(dbConnection, inode);
    }

    private boolean removeFile(Connection dbConnection, FsInode parent, FsInode inode, String name2) throws ChimeraFsException, SQLException {
        boolean isLast = inode.stat().getNlink() == 1;
        this.decNlink(dbConnection, inode);
        this.removeEntryInParent(dbConnection, parent, name2);
        this.decNlink(dbConnection, parent);
        this.setFileMTime(dbConnection, parent, 0, System.currentTimeMillis());
        if (isLast) {
            return this.removeInode(dbConnection, inode);
        }
        return true;
    }

    boolean remove(Connection dbConnection, FsInode parent, FsInode inode) throws ChimeraFsException, SQLException {
        if (inode.isDirectory()) {
            Stat dirStat = inode.statCache();
            if (dirStat.getNlink() > 2) {
                throw new ChimeraFsException("directory is not empty");
            }
            this.removeEntryInParent(dbConnection, inode, ".");
            this.removeEntryInParent(dbConnection, inode, "..");
            this.decNlink(dbConnection, inode, 2);
            this.removeTag(dbConnection, inode);
        } else {
            this.decNlink(dbConnection, inode);
        }
        this.removeEntryInParentByID(dbConnection, parent, inode);
        this.decNlink(dbConnection, parent);
        this.setFileMTime(dbConnection, parent, 0, System.currentTimeMillis());
        this.removeStorageInfo(dbConnection, inode);
        return this.removeInode(dbConnection, inode);
    }

    public Stat stat(Connection dbConnection, FsInode inode) throws SQLException {
        return this.stat(dbConnection, inode, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat stat(Connection dbConnection, FsInode inode, int level) throws SQLException {
        Stat ret = null;
        PreparedStatement stStatInode = null;
        ResultSet statResult = null;
        try {
            stStatInode = level == 0 ? dbConnection.prepareStatement(sqlStat) : dbConnection.prepareStatement("SELECT isize,inlink,imode,iuid,igid,iatime,ictime,imtime FROM t_level_" + level + " WHERE ipnfsid=?");
            stStatInode.setString(1, inode.toString());
            statResult = stStatInode.executeQuery();
            if (statResult.next()) {
                int inodeType;
                ret = new Stat();
                if (level == 0) {
                    inodeType = statResult.getInt("itype");
                    ret.setCrTime(statResult.getTimestamp("icrtime").getTime());
                } else {
                    inodeType = 32768;
                    ret.setCrTime(statResult.getTimestamp("imtime").getTime());
                }
                ret.setSize(statResult.getLong("isize"));
                ret.setATime(statResult.getTimestamp("iatime").getTime());
                ret.setCTime(statResult.getTimestamp("ictime").getTime());
                ret.setMTime(statResult.getTimestamp("imtime").getTime());
                ret.setUid(statResult.getInt("iuid"));
                ret.setGid(statResult.getInt("igid"));
                ret.setMode(statResult.getInt("imode") | inodeType);
                ret.setNlink(statResult.getInt("inlink"));
                ret.setIno((int)inode.id());
                ret.setDev(17);
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(statResult);
            SqlHelper.tryToClose(stStatInode);
            throw throwable;
        }
        SqlHelper.tryToClose(statResult);
        SqlHelper.tryToClose(stStatInode);
        return ret;
    }

    FsInode mkdir(Connection dbConnection, FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException, SQLException {
        FsInode inode = null;
        if (!parent.isDirectory()) {
            throw new NotDirChimeraException(parent);
        }
        inode = new FsInode(parent.getFs());
        this.createInode(dbConnection, inode, 16384, owner, group, mode, 2);
        this.createEntryInParent(dbConnection, parent, name2, inode);
        this.incNlink(dbConnection, parent);
        this.createEntryInParent(dbConnection, inode, ".", inode);
        this.createEntryInParent(dbConnection, inode, "..", parent);
        return inode;
    }

    FsInode mkdirIfNotExists(Connection dbConnection, FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException, SQLException {
        FsInode inode = null;
        inode = this.inodeOf(dbConnection, parent, name2);
        if (inode == null) {
            return this.mkdir(dbConnection, parent, name2, owner, group, mode);
        }
        return inode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void move(Connection dbConnection, FsInode srcDir, String source, FsInode destDir, String dest) throws SQLException, ChimeraFsException {
        block4: {
            stMove = null;
            stParentMove = null;
            try {
                destInode = this.inodeOf(dbConnection, destDir, dest);
                srcInode = this.inodeOf(dbConnection, srcDir, source);
                if (destInode == null) ** GOTO lbl19
                if (!destInode.equals(srcInode)) break block4;
            }
            catch (Throwable var11_11) {
                SqlHelper.tryToClose(stMove);
                SqlHelper.tryToClose(stParentMove);
                throw var11_11;
            }
            SqlHelper.tryToClose(stMove);
            SqlHelper.tryToClose(stParentMove);
            return;
        }
        this.remove(dbConnection, destDir, dest);
lbl19:
        // 2 sources

        this.incNlink(dbConnection, destDir);
        stMove = dbConnection.prepareStatement("UPDATE t_dirs SET iparent=?, iname=? WHERE iparent=? AND iname=?");
        stMove.setString(1, destDir.toString());
        stMove.setString(2, dest);
        stMove.setString(3, srcDir.toString());
        stMove.setString(4, source);
        stMove.executeUpdate();
        stat = this.stat(dbConnection, srcInode);
        if ((stat.getMode() & 16384) != 0) {
            stParentMove = dbConnection.prepareStatement("UPDATE t_dirs SET ipnfsid=? WHERE iparent=? AND iname='..'");
            stParentMove.setString(1, destDir.toString());
            stParentMove.setString(2, srcInode.toString());
            stParentMove.executeUpdate();
        }
        this.decNlink(dbConnection, srcDir);
        SqlHelper.tryToClose(stMove);
        SqlHelper.tryToClose(stParentMove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FsInode inodeOf(Connection dbConnection, FsInode parent, String name2) throws SQLException {
        FsInode inode = null;
        String id = null;
        PreparedStatement stGetInodeByName = null;
        ResultSet result = null;
        try {
            stGetInodeByName = dbConnection.prepareStatement(sqlInodeOf);
            stGetInodeByName.setString(1, name2);
            stGetInodeByName.setString(2, parent.toString());
            result = stGetInodeByName.executeQuery();
            if (result.next()) {
                id = result.getString("ipnfsid");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose(stGetInodeByName);
            throw throwable;
        }
        SqlHelper.tryToClose(result);
        SqlHelper.tryToClose(stGetInodeByName);
        if (id != null) {
            inode = new FsInode(parent.getFs(), id);
        }
        return inode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String inode2path(Connection dbConnection, FsInode inode, FsInode startFrom, boolean inclusive) throws SQLException {
        String path = null;
        PreparedStatement ps = null;
        try {
            ArrayList<String> pList = new ArrayList<String>();
            String parentId = this.getParentOf(dbConnection, inode).toString();
            String elementId = inode.toString();
            boolean done = false;
            do {
                ps = dbConnection.prepareStatement(sqlInode2Path_name);
                ps.setString(1, elementId);
                ps.setString(2, parentId);
                ResultSet pSearch = ps.executeQuery();
                if (pSearch.next()) {
                    pList.add(pSearch.getString("iname"));
                }
                elementId = parentId;
                SqlHelper.tryToClose(ps);
                if (inclusive && elementId.equals(startFrom.toString())) {
                    done = true;
                }
                ps = dbConnection.prepareStatement(sqlInode2Path_inode);
                ps.setString(1, parentId);
                pSearch = ps.executeQuery();
                if (pSearch.next()) {
                    parentId = pSearch.getString("iparent");
                }
                ps.close();
                if (inclusive || !parentId.equals(startFrom.toString())) continue;
                done = true;
            } while (!done);
            StringBuilder sb = new StringBuilder();
            for (int i = pList.size(); i > 0; --i) {
                sb.append("/").append((String)pList.get(i - 1));
            }
            path = sb.toString();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInode(Connection dbConnection, FsInode inode, int type, int uid, int gid, int mode, int nlink) throws SQLException {
        PreparedStatement stCreateInode = null;
        try {
            stCreateInode = dbConnection.prepareStatement(sqlCreateInode);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            stCreateInode.setString(1, inode.toString());
            stCreateInode.setInt(2, type);
            stCreateInode.setInt(3, mode & 0x1FF);
            stCreateInode.setInt(4, nlink);
            stCreateInode.setInt(5, uid);
            stCreateInode.setInt(6, gid);
            stCreateInode.setLong(7, type == 16384 ? 512L : 0L);
            stCreateInode.setInt(8, this._ioMode);
            stCreateInode.setTimestamp(9, now);
            stCreateInode.setTimestamp(10, now);
            stCreateInode.setTimestamp(11, now);
            stCreateInode.setTimestamp(12, now);
            stCreateInode.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stCreateInode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FsInode createLevel(Connection dbConnection, FsInode inode, int uid, int gid, int mode, int level) throws SQLException {
        PreparedStatement stCreateInodeLevel = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            stCreateInodeLevel = dbConnection.prepareStatement("INSERT INTO t_level_" + level + " VALUES(?,?,1,?,?,0,?,?,?, NULL)");
            stCreateInodeLevel.setString(1, inode.toString());
            stCreateInodeLevel.setInt(2, mode);
            stCreateInodeLevel.setInt(3, uid);
            stCreateInodeLevel.setInt(4, gid);
            stCreateInodeLevel.setTimestamp(5, now);
            stCreateInodeLevel.setTimestamp(6, now);
            stCreateInodeLevel.setTimestamp(7, now);
            stCreateInodeLevel.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(stCreateInodeLevel);
            throw throwable;
        }
        SqlHelper.tryToClose(stCreateInodeLevel);
        return new FsInode(inode.getFs(), inode.toString(), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeInode(Connection dbConnection, FsInode inode) throws SQLException {
        int rc = 0;
        PreparedStatement stRemoveInode = null;
        try {
            stRemoveInode = dbConnection.prepareStatement(sqlRemoveInode);
            stRemoveInode.setString(1, inode.toString());
            rc = stRemoveInode.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stRemoveInode);
        }
        return rc > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeInodeLevel(Connection dbConnection, FsInode inode, int level) throws ChimeraFsException, SQLException {
        int rc = 0;
        PreparedStatement stRemoveInodeLevel = null;
        try {
            stRemoveInodeLevel = dbConnection.prepareStatement("DELETE FROM t_level_" + level + " WHERE ipnfsid=?");
            stRemoveInodeLevel.setString(1, inode.toString());
            rc = stRemoveInodeLevel.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(stRemoveInodeLevel);
            throw throwable;
        }
        SqlHelper.tryToClose(stRemoveInodeLevel);
        return rc > 0;
    }

    void incNlink(Connection dbConnection, FsInode inode) throws SQLException {
        this.incNlink(dbConnection, inode, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incNlink(Connection dbConnection, FsInode inode, int delta) throws SQLException {
        PreparedStatement stIncNlinkCount = null;
        try {
            stIncNlinkCount = dbConnection.prepareStatement(sqlIncNlink);
            stIncNlinkCount.setInt(1, delta);
            stIncNlinkCount.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stIncNlinkCount.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            stIncNlinkCount.setString(4, inode.toString());
            stIncNlinkCount.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stIncNlinkCount);
        }
    }

    void decNlink(Connection dbConnection, FsInode inode) throws SQLException {
        this.decNlink(dbConnection, inode, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decNlink(Connection dbConnection, FsInode inode, int delta) throws SQLException {
        PreparedStatement stDecNlinkCount = null;
        try {
            stDecNlinkCount = dbConnection.prepareStatement(sqlDecNlink);
            stDecNlinkCount.setInt(1, delta);
            stDecNlinkCount.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stDecNlinkCount.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            stDecNlinkCount.setString(4, inode.toString());
            stDecNlinkCount.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stDecNlinkCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEntryInParent(Connection dbConnection, FsInode parent, String name2, FsInode inode) throws SQLException, InvalidNameChimeraException {
        PreparedStatement stInserIntoParent = null;
        try {
            stInserIntoParent = dbConnection.prepareStatement(sqlCreateEntryInParent);
            stInserIntoParent.setString(1, parent.toString());
            stInserIntoParent.setString(2, name2);
            stInserIntoParent.setString(3, inode.toString());
            stInserIntoParent.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stInserIntoParent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryInParentByID(Connection dbConnection, FsInode parent, FsInode inode) throws SQLException {
        PreparedStatement stRemoveFromParentById = null;
        try {
            stRemoveFromParentById = dbConnection.prepareStatement(sqlRemoveEntryInParentByID);
            stRemoveFromParentById.setString(1, inode.toString());
            stRemoveFromParentById.setString(2, parent.toString());
            stRemoveFromParentById.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stRemoveFromParentById);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryInParent(Connection dbConnection, FsInode parent, String name2) throws SQLException {
        PreparedStatement stRemoveFromParentByName = null;
        try {
            stRemoveFromParentByName = dbConnection.prepareStatement(sqlRemoveEntryInParentByName);
            stRemoveFromParentByName.setString(1, name2);
            stRemoveFromParentByName.setString(2, parent.toString());
            stRemoveFromParentByName.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stRemoveFromParentByName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FsInode getParentOf(Connection dbConnection, FsInode inode) throws SQLException {
        FsInode parent = null;
        ResultSet result = null;
        PreparedStatement stGetParentId = null;
        try {
            stGetParentId = dbConnection.prepareStatement(sqlGetParentOf);
            stGetParentId.setString(1, inode.toString());
            result = stGetParentId.executeQuery();
            if (result.next()) {
                parent = new FsInode(inode.getFs(), result.getString("iparent"));
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose(stGetParentId);
            throw throwable;
        }
        SqlHelper.tryToClose(result);
        SqlHelper.tryToClose(stGetParentId);
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FsInode getParentOfDirectory(Connection dbConnection, FsInode inode) throws SQLException {
        FsInode parent = null;
        ResultSet result = null;
        PreparedStatement stGetParentId = null;
        try {
            stGetParentId = dbConnection.prepareStatement(sqlGetParentOfDirectory);
            stGetParentId.setString(1, inode.toString());
            result = stGetParentId.executeQuery();
            if (result.next()) {
                parent = new FsInode(inode.getFs(), result.getString("iparent"));
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose(stGetParentId);
            throw throwable;
        }
        SqlHelper.tryToClose(result);
        SqlHelper.tryToClose(stGetParentId);
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNameOf(Connection dbConnection, FsInode parent, FsInode inode) throws SQLException {
        ResultSet result = null;
        PreparedStatement stGetName = null;
        String name2 = null;
        try {
            stGetName = dbConnection.prepareStatement(sqlGetNameOf);
            stGetName.setString(1, inode.toString());
            stGetName.setString(2, parent.toString());
            result = stGetName.executeQuery();
            if (result.next()) {
                name2 = result.getString("iname");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose(stGetName);
            throw throwable;
        }
        SqlHelper.tryToClose(result);
        SqlHelper.tryToClose(stGetName);
        return name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSize(Connection dbConnection, FsInode inode, long newSize) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = dbConnection.prepareStatement(sqlSetFileSize);
            ps.setLong(1, newSize);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            ps.setString(4, inode.toString());
            ps.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileOwner(Connection dbConnection, FsInode inode, int level, int newOwner) throws SQLException {
        PreparedStatement ps = null;
        try {
            String fileSetModeQuery = null;
            fileSetModeQuery = level == 0 ? sqlSetFileOwner : "UPDATE t_level_" + level + " SET iuid=?,ictime=? WHERE ipnfsid=?";
            ps = dbConnection.prepareStatement(fileSetModeQuery);
            ps.setInt(1, newOwner);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, inode.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void setFileName(Connection dbConnection, FsInode dir, String oldName, String newName) throws SQLException, ChimeraFsException {
        block3: {
            ps = null;
            try {
                destInode = this.inodeOf(dbConnection, dir, newName);
                srcInode = this.inodeOf(dbConnection, dir, oldName);
                if (destInode == null) ** GOTO lbl16
                if (!destInode.equals(srcInode)) break block3;
            }
            catch (Throwable var8_8) {
                SqlHelper.tryToClose(ps);
                throw var8_8;
            }
            SqlHelper.tryToClose(ps);
            return;
        }
        this.remove(dbConnection, dir, newName);
lbl16:
        // 2 sources

        ps = dbConnection.prepareStatement("UPDATE t_dirs SET iname=? WHERE iname=? AND iparent=?");
        ps.setString(1, newName);
        ps.setString(2, oldName);
        ps.setString(3, dir.toString());
        ps.executeUpdate();
        this.setFileMTime(dbConnection, dir, 0, System.currentTimeMillis());
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInodeAttributes(Connection dbConnection, FsInode inode, int level, Stat stat) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (level == 0) {
                ps = dbConnection.prepareStatement(sqlSetInodeAttributes);
                ps.setTimestamp(1, new Timestamp(stat.getATime()));
                ps.setTimestamp(2, new Timestamp(stat.getMTime()));
                ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                ps.setLong(4, stat.getSize());
                ps.setInt(5, stat.getUid());
                ps.setInt(6, stat.getGid());
                ps.setInt(7, stat.getMode() & 0x1FF);
                ps.setInt(8, stat.getMode() & 0x3F000);
                ps.setString(9, inode.toString());
            } else {
                String fileSetModeQuery = "UPDATE t_level_" + level + " SET iatime=?, imtime=?, iuid=?, igid=?, imode=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(fileSetModeQuery);
                ps.setTimestamp(1, new Timestamp(stat.getATime()));
                ps.setTimestamp(2, new Timestamp(stat.getMTime()));
                ps.setInt(3, stat.getUid());
                ps.setInt(4, stat.getGid());
                ps.setInt(5, stat.getMode());
                ps.setString(6, inode.toString());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileATime(Connection dbConnection, FsInode inode, int level, long atime) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (level == 0) {
                ps = dbConnection.prepareStatement(sqlSetFileATime);
            } else {
                String fileSetModeQuery = "UPDATE t_level_" + level + " SET iatime=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(fileSetModeQuery);
            }
            ps.setTimestamp(1, new Timestamp(atime));
            ps.setString(2, inode.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileCTime(Connection dbConnection, FsInode inode, int level, long ctime) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (level == 0) {
                ps = dbConnection.prepareStatement(sqlSetFileCTime);
            } else {
                String fileSetModeQuery = "UPDATE t_level_" + level + " SET ictime=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(fileSetModeQuery);
            }
            ps.setTimestamp(1, new Timestamp(ctime));
            ps.setString(2, inode.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileMTime(Connection dbConnection, FsInode inode, int level, long mtime) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (level == 0) {
                ps = dbConnection.prepareStatement(sqlSetFileMTime);
            } else {
                String fileSetModeQuery = "UPDATE t_level_" + level + " SET imtime=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(fileSetModeQuery);
            }
            ps.setTimestamp(1, new Timestamp(mtime));
            ps.setString(2, inode.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileGroup(Connection dbConnection, FsInode inode, int level, int newGroup) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (level == 0) {
                ps = dbConnection.prepareStatement(sqlSetFileGroup);
            } else {
                String fileSetModeQuery = "UPDATE t_level_" + level + " SET igid=?,ictime=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(fileSetModeQuery);
            }
            ps.setInt(1, newGroup);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, inode.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileMode(Connection dbConnection, FsInode inode, int level, int newMode) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (level == 0) {
                ps = dbConnection.prepareStatement(sqlSetFileMode);
            } else {
                String fileSetModeQuery = "UPDATE t_level_" + level + " SET imode=?,ictime=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(fileSetModeQuery);
            }
            ps.setInt(1, newMode & 0x1FF);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, inode.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIoEnabled(Connection dbConnection, FsInode inode) throws SQLException {
        boolean ioEnabled = false;
        ResultSet rs = null;
        PreparedStatement stIsIoEnabled = null;
        try {
            stIsIoEnabled = dbConnection.prepareStatement(sqlIsIoEnabled);
            stIsIoEnabled.setString(1, inode.toString());
            rs = stIsIoEnabled.executeQuery();
            if (rs.next()) {
                ioEnabled = rs.getInt("iio") == 1;
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stIsIoEnabled);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stIsIoEnabled);
        return ioEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInodeIo(Connection dbConnection, FsInode inode, boolean enable) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = dbConnection.prepareStatement(sqlSetInodeIo);
            ps.setInt(1, enable ? 1 : 0);
            ps.setString(2, inode.toString());
            ps.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int write(Connection dbConnection, FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement ps;
        block8: {
            ps = null;
            rs = null;
            try {
                if (level == 0) {
                    String writeStream;
                    ps = dbConnection.prepareStatement("SELECT ipnfsid FROM t_inodes_data WHERE ipnfsid=?");
                    ps.setString(1, inode.toString());
                    rs = ps.executeQuery();
                    boolean exist = rs.next();
                    SqlHelper.tryToClose(rs);
                    SqlHelper.tryToClose(ps);
                    if (exist) {
                        ps = dbConnection.prepareStatement("SELECT ifiledata FROM t_inodes_data WHERE ipnfsid=?");
                        ps.setString(1, inode.toString());
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            InputStream in = rs.getBinaryStream(1);
                            String writeStream2 = "UPDATE t_inodes_data SET ifiledata=? WHERE ipnfsid=?";
                            ps = dbConnection.prepareStatement(writeStream2);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            int next = in.read();
                            for (long curr = 0L; next > -1 && curr != beginIndex; ++curr) {
                                bos.write(next);
                                next = in.read();
                            }
                            bos.flush();
                            byte[] currentBytes = bos.toByteArray();
                            byte[] newBytes = new byte[currentBytes.length + data.length];
                            System.arraycopy(currentBytes, 0, newBytes, 0, currentBytes.length);
                            System.arraycopy(data, 0, newBytes, currentBytes.length, data.length);
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(newBytes);
                            ps.setBinaryStream(1, (InputStream)byteArrayInputStream, newBytes.length);
                            ps.setString(2, inode.toString());
                            ps.executeUpdate();
                            SqlHelper.tryToClose(ps);
                        }
                    } else {
                        writeStream = "INSERT INTO t_inodes_data VALUES (?,?)";
                        ps = dbConnection.prepareStatement(writeStream);
                        ps.setString(1, inode.toString());
                        ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(data, offset, len), len);
                        ps.executeUpdate();
                        SqlHelper.tryToClose(ps);
                    }
                    writeStream = "UPDATE t_inodes SET isize=? WHERE ipnfsid=?";
                    ps = dbConnection.prepareStatement(writeStream);
                    ps.setLong(1, beginIndex + (long)len);
                    ps.setString(2, inode.toString());
                    ps.executeUpdate();
                    break block8;
                }
                if (this.stat(dbConnection, inode, level) == null) {
                    this.createLevel(dbConnection, inode, 0, 0, 644, level);
                }
                String writeStream = "UPDATE t_level_" + level + " SET ifiledata=?,isize=? WHERE ipnfsid=?";
                ps = dbConnection.prepareStatement(writeStream);
                ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data, offset, len), len);
                ps.setLong(2, len);
                ps.setString(3, inode.toString());
                ps.executeUpdate();
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(rs);
                SqlHelper.tryToClose(ps);
                throw throwable;
            }
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(ps);
        return len;
    }

    int read(Connection dbConnection, FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws SQLException, IOHimeraFsException {
        int count;
        PreparedStatement stReadFromInode = null;
        ResultSet rs = null;
        try {
            stReadFromInode = level == 0 ? dbConnection.prepareStatement("SELECT ifiledata FROM t_inodes_data WHERE ipnfsid=?") : dbConnection.prepareStatement("SELECT ifiledata FROM t_level_" + level + " WHERE ipnfsid=?");
            stReadFromInode.setString(1, inode.toString());
            rs = stReadFromInode.executeQuery();
            if (rs.next()) {
                int c;
                InputStream in = rs.getBinaryStream(1);
                in.skip(beginIndex);
                for (count = 0; (c = in.read()) != -1 && count < len; ++count) {
                    data[offset + count] = (byte)c;
                }
            }
        }
        catch (IOException e) {
            try {
                throw new IOHimeraFsException(e.toString());
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(rs);
                SqlHelper.tryToClose(stReadFromInode);
                throw throwable;
            }
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stReadFromInode);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StorageLocatable> getInodeLocations(Connection dbConnection, FsInode inode, int type) throws ChimeraFsException, SQLException {
        ArrayList<StorageLocatable> locations = new ArrayList<StorageLocatable>();
        ResultSet rs = null;
        PreparedStatement stGetInodeLocations = null;
        try {
            stGetInodeLocations = dbConnection.prepareStatement(sqlGetInodeLocations);
            stGetInodeLocations.setInt(1, type);
            stGetInodeLocations.setString(2, inode.toString());
            rs = stGetInodeLocations.executeQuery();
            while (rs.next()) {
                long ctime = rs.getTimestamp("ictime").getTime();
                long atime = rs.getTimestamp("iatime").getTime();
                int priority = rs.getInt("ipriority");
                String location = rs.getString("ilocation");
                StorageGenericLocation inodeLocation = new StorageGenericLocation(type, priority, location, ctime, atime, true);
                locations.add(inodeLocation);
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stGetInodeLocations);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stGetInodeLocations);
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInodeLocation(Connection dbConnection, FsInode inode, int type, String location) throws ChimeraFsException, SQLException {
        PreparedStatement stAddInodeLocation = null;
        try {
            stAddInodeLocation = dbConnection.prepareStatement(sqlAddInodeLocation);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            stAddInodeLocation.setString(1, inode.toString());
            stAddInodeLocation.setInt(2, type);
            stAddInodeLocation.setString(3, location);
            stAddInodeLocation.setInt(4, 10);
            stAddInodeLocation.setTimestamp(5, now);
            stAddInodeLocation.setTimestamp(6, now);
            stAddInodeLocation.setInt(7, 1);
            stAddInodeLocation.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stAddInodeLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearInodeLocation(Connection dbConnection, FsInode inode, int type, String location) throws ChimeraFsException, SQLException {
        PreparedStatement stClearInodeLocation = null;
        try {
            stClearInodeLocation = dbConnection.prepareStatement(sqlClearInodeLocation);
            stClearInodeLocation.setString(1, inode.toString());
            stClearInodeLocation.setInt(2, type);
            stClearInodeLocation.setString(3, location);
            stClearInodeLocation.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stClearInodeLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearInodeLocations(Connection dbConnection, FsInode inode) throws ChimeraFsException, SQLException {
        PreparedStatement stClearInodeLocations = null;
        try {
            stClearInodeLocations = dbConnection.prepareStatement(sqlClearInodeLocations);
            stClearInodeLocations.setString(1, inode.toString());
            stClearInodeLocations.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stClearInodeLocations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] tags(Connection dbConnection, FsInode inode) throws SQLException {
        String[] list = null;
        ResultSet rs = null;
        PreparedStatement stGetTags = null;
        try {
            stGetTags = dbConnection.prepareStatement(sqlTags);
            stGetTags.setString(1, inode.toString());
            rs = stGetTags.executeQuery();
            ArrayList<String> v = new ArrayList<String>();
            while (rs.next()) {
                v.add(rs.getString("itagname"));
            }
            rs.close();
            list = v.toArray(new String[v.size()]);
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stGetTags);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stGetTags);
        return list;
    }

    void createTag(Connection dbConnection, FsInode inode, String name2, int uid, int gid, int mode) throws SQLException {
        String id = this.createTagInode(dbConnection, uid, gid, mode);
        this.assignTagToDir(dbConnection, id, name2, inode, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTagId(Connection dbConnection, FsInode dir, String tag) throws SQLException {
        String tagId = null;
        ResultSet rs = null;
        PreparedStatement stGetTagId = null;
        try {
            stGetTagId = dbConnection.prepareStatement(sqlGetTagId);
            stGetTagId.setString(1, dir.toString());
            stGetTagId.setString(2, tag);
            rs = stGetTagId.executeQuery();
            if (rs.next()) {
                tagId = rs.getString("itagid");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stGetTagId);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stGetTagId);
        return tagId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String createTagInode(Connection dbConnection, int uid, int gid, int mode) throws SQLException {
        String id = UUID.randomUUID().toString().toUpperCase();
        PreparedStatement stCreateTagInode = null;
        try {
            stCreateTagInode = dbConnection.prepareStatement(sqlCreateTagInode);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            stCreateTagInode.setString(1, id);
            stCreateTagInode.setInt(2, mode | 0x8000);
            stCreateTagInode.setInt(3, uid);
            stCreateTagInode.setInt(4, gid);
            stCreateTagInode.setTimestamp(5, now);
            stCreateTagInode.setTimestamp(6, now);
            stCreateTagInode.setTimestamp(7, now);
            stCreateTagInode.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stCreateTagInode);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assignTagToDir(Connection dbConnection, String tagId, String tagName, FsInode dir, boolean isUpdate, boolean isOrign) throws SQLException {
        PreparedStatement ps = null;
        try {
            if (isUpdate) {
                ps = dbConnection.prepareStatement(sqlAssignTagToDir_update);
                ps.setString(1, tagId);
                ps.setInt(2, isOrign ? 1 : 0);
                ps.setString(3, dir.toString());
                ps.setString(4, tagName);
            } else {
                ps = dbConnection.prepareStatement(sqlAssignTagToDir_add);
                ps.setString(1, dir.toString());
                ps.setString(2, tagName);
                ps.setString(3, tagId);
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(ps);
            throw throwable;
        }
        SqlHelper.tryToClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setTag(Connection dbConnection, FsInode inode, String tagName, byte[] data, int offset, int len) throws SQLException, ChimeraFsException {
        PreparedStatement stSetTag = null;
        try {
            String tagId = this.getTagId(dbConnection, inode, tagName);
            if (!this.isTagOwner(dbConnection, inode, tagName)) {
                Stat tagStat = this.statTag(dbConnection, inode, tagName);
                tagId = this.createTagInode(dbConnection, tagStat.getUid(), tagStat.getGid(), tagStat.getMode());
                this.assignTagToDir(dbConnection, tagId, tagName, inode, true, true);
            }
            stSetTag = dbConnection.prepareStatement(sqlSetTag);
            stSetTag.setBinaryStream(1, (InputStream)new ByteArrayInputStream(data, offset, len), len);
            stSetTag.setLong(2, len);
            stSetTag.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            stSetTag.setString(4, tagId);
            stSetTag.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(stSetTag);
            throw throwable;
        }
        SqlHelper.tryToClose(stSetTag);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTag(Connection dbConnection, FsInode dir) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = dbConnection.prepareStatement(sqlRemoveTag);
            ps.setString(1, dir.toString());
            ps.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTag(Connection dbConnection, FsInode inode, String tagName, byte[] data, int offset, int len) throws SQLException, IOException {
        int count;
        ResultSet rs = null;
        PreparedStatement stGetTag = null;
        try {
            String tagId = this.getTagId(dbConnection, inode, tagName);
            stGetTag = dbConnection.prepareStatement(sqlGetTag);
            stGetTag.setString(1, tagId);
            rs = stGetTag.executeQuery();
            if (rs.next()) {
                int c;
                InputStream in = rs.getBinaryStream("ivalue");
                int size = Math.min(len, (int)rs.getLong("isize"));
                for (count = 0; count < size && (c = in.read()) != -1; ++count) {
                    data[offset + count] = (byte)c;
                }
                in.close();
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stGetTag);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stGetTag);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Stat statTag(Connection dbConnection, FsInode dir, String name2) throws ChimeraFsException, SQLException {
        Stat ret = new Stat();
        PreparedStatement stStatTag = null;
        try {
            String tagId = this.getTagId(dbConnection, dir, name2);
            if (tagId == null) {
                throw new FileNotFoundHimeraFsException("tag do not exist");
            }
            stStatTag = dbConnection.prepareStatement(sqlStatTag);
            stStatTag.setString(1, tagId);
            ResultSet statResult = stStatTag.executeQuery();
            if (!statResult.next()) {
                throw new FileNotFoundHimeraFsException(name2);
            }
            ret.setSize(statResult.getLong("isize"));
            ret.setATime(statResult.getTimestamp("iatime").getTime());
            ret.setCTime(statResult.getTimestamp("ictime").getTime());
            ret.setMTime(statResult.getTimestamp("imtime").getTime());
            ret.setUid(statResult.getInt("iuid"));
            ret.setGid(statResult.getInt("igid"));
            ret.setMode(statResult.getInt("imode"));
            ret.setNlink(statResult.getInt("inlink"));
            ret.setIno((int)dir.id());
            ret.setDev(17);
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(stStatTag);
            throw throwable;
        }
        SqlHelper.tryToClose(stStatTag);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTagOwner(Connection dbConnection, FsInode dir, String tagName) throws SQLException {
        boolean isOwner = false;
        PreparedStatement stTagOwner = null;
        ResultSet rs = null;
        try {
            int rc;
            stTagOwner = dbConnection.prepareStatement(sqlIsTagOwner);
            stTagOwner.setString(1, dir.toString());
            stTagOwner.setString(2, tagName);
            rs = stTagOwner.executeQuery();
            if (rs.next() && (rc = rs.getInt("isorign")) == 1) {
                isOwner = true;
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stTagOwner);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stTagOwner);
        return isOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTags(Connection dbConnection, FsInode orign, FsInode destination) throws SQLException {
        PreparedStatement stCopyTags = null;
        try {
            stCopyTags = dbConnection.prepareStatement(sqlCopyTag);
            stCopyTags.setString(1, destination.toString());
            stCopyTags.setString(2, orign.toString());
            stCopyTags.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stCopyTags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTagOwner(Connection dbConnection, FsInode_TAG tagInode, int newOwner) throws SQLException {
        PreparedStatement ps = null;
        String tagId = this.getTagId(dbConnection, tagInode, tagInode.tagName());
        try {
            ps = dbConnection.prepareStatement(sqlSetTagOwner);
            ps.setInt(1, newOwner);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, tagId);
            ps.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTagOwnerGroup(Connection dbConnection, FsInode_TAG tagInode, int newOwner) throws SQLException {
        PreparedStatement ps = null;
        String tagId = this.getTagId(dbConnection, tagInode, tagInode.tagName());
        try {
            ps = dbConnection.prepareStatement(sqlSetTagOwnerGroup);
            ps.setInt(1, newOwner);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, tagId);
            ps.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTagMode(Connection dbConnection, FsInode_TAG tagInode, int mode) throws SQLException {
        PreparedStatement ps = null;
        String tagId = this.getTagId(dbConnection, tagInode, tagInode.tagName());
        try {
            ps = dbConnection.prepareStatement(sqlSetTagMode);
            ps.setInt(1, mode & 0x1FF);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.setString(3, tagId);
            ps.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStorageInfo(Connection dbConnection, FsInode inode, InodeStorageInformation storageInfo) throws ChimeraFsException, SQLException {
        PreparedStatement stSetStorageInfo = null;
        try {
            stSetStorageInfo = dbConnection.prepareStatement(sqlSetStorageInfo);
            stSetStorageInfo.setString(1, inode.toString());
            stSetStorageInfo.setString(2, storageInfo.hsmName());
            stSetStorageInfo.setString(3, storageInfo.storageGroup());
            stSetStorageInfo.setString(4, storageInfo.storageSubGroup());
            stSetStorageInfo.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stSetStorageInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessLatency getAccessLatency(Connection dbConnection, FsInode inode) throws ChimeraFsException, SQLException {
        AccessLatency accessLatency = null;
        PreparedStatement stGetAccessLatency = null;
        ResultSet alResultSet = null;
        try {
            stGetAccessLatency = dbConnection.prepareStatement(sqlGetAccessLatency);
            stGetAccessLatency.setString(1, inode.toString());
            alResultSet = stGetAccessLatency.executeQuery();
            if (alResultSet.next()) {
                accessLatency = AccessLatency.valueOf(alResultSet.getInt("iaccessLatency"));
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(alResultSet);
            SqlHelper.tryToClose(stGetAccessLatency);
            throw throwable;
        }
        SqlHelper.tryToClose(alResultSet);
        SqlHelper.tryToClose(stGetAccessLatency);
        return accessLatency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RetentionPolicy getRetentionPolicy(Connection dbConnection, FsInode inode) throws ChimeraFsException, SQLException {
        RetentionPolicy retentionPolicy = null;
        PreparedStatement stRetentionPolicy = null;
        ResultSet rpResultSet = null;
        try {
            stRetentionPolicy = dbConnection.prepareStatement(sqlGetRetentionPolicy);
            stRetentionPolicy.setString(1, inode.toString());
            rpResultSet = stRetentionPolicy.executeQuery();
            if (rpResultSet.next()) {
                retentionPolicy = RetentionPolicy.valueOf(rpResultSet.getInt("iretentionPolicy"));
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rpResultSet);
            SqlHelper.tryToClose(stRetentionPolicy);
            throw throwable;
        }
        SqlHelper.tryToClose(rpResultSet);
        SqlHelper.tryToClose(stRetentionPolicy);
        return retentionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAccessLatency(Connection dbConnection, FsInode inode, AccessLatency accessLatency) throws ChimeraFsException, SQLException {
        PreparedStatement stSetAccessLatency = null;
        PreparedStatement stUpdateAccessLatency = null;
        try {
            stUpdateAccessLatency = dbConnection.prepareStatement(sqlUpdateAccessLatency);
            stUpdateAccessLatency.setInt(1, accessLatency.getId());
            stUpdateAccessLatency.setString(2, inode.toString());
            if (stUpdateAccessLatency.executeUpdate() == 0) {
                stSetAccessLatency = dbConnection.prepareStatement(sqlSetAccessLatency);
                stSetAccessLatency.setString(1, inode.toString());
                stSetAccessLatency.setInt(2, accessLatency.getId());
                stSetAccessLatency.executeUpdate();
            }
        }
        finally {
            SqlHelper.tryToClose(stSetAccessLatency);
            SqlHelper.tryToClose(stUpdateAccessLatency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRetentionPolicy(Connection dbConnection, FsInode inode, RetentionPolicy accessLatency) throws ChimeraFsException, SQLException {
        PreparedStatement stSetRetentionPolicy = null;
        PreparedStatement stUpdateRetentionPolicy = null;
        try {
            stUpdateRetentionPolicy = dbConnection.prepareStatement(sqlUpdateRetentionPolicy);
            stUpdateRetentionPolicy.setInt(1, accessLatency.getId());
            stUpdateRetentionPolicy.setString(2, inode.toString());
            if (stUpdateRetentionPolicy.executeUpdate() == 0) {
                stSetRetentionPolicy = dbConnection.prepareStatement(sqlSetRetentionPolicy);
                stSetRetentionPolicy.setString(1, inode.toString());
                stSetRetentionPolicy.setInt(2, accessLatency.getId());
                stSetRetentionPolicy.executeUpdate();
            }
        }
        finally {
            SqlHelper.tryToClose(stSetRetentionPolicy);
            SqlHelper.tryToClose(stUpdateRetentionPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStorageInfo(Connection dbConnection, FsInode inode) throws ChimeraFsException, SQLException {
        PreparedStatement stRemoveStorageInfo = null;
        try {
            stRemoveStorageInfo = dbConnection.prepareStatement(sqlRemoveStorageInfo);
            stRemoveStorageInfo.setString(1, inode.toString());
            stRemoveStorageInfo.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stRemoveStorageInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InodeStorageInformation getSorageInfo(Connection dbConnection, FsInode inode) throws ChimeraFsException, SQLException {
        InodeStorageInformation storageInfo = null;
        ResultSet storageInfoResult = null;
        PreparedStatement stGetStorageInfo = null;
        try {
            stGetStorageInfo = dbConnection.prepareStatement(sqlGetStorageInfo);
            stGetStorageInfo.setString(1, inode.toString());
            storageInfoResult = stGetStorageInfo.executeQuery();
            if (!storageInfoResult.next()) {
                throw new FileNotFoundHimeraFsException(inode.toString());
            }
            String hsmName = storageInfoResult.getString("ihsmName");
            String storageGroup = storageInfoResult.getString("istoragegroup");
            String storageSubGroup = storageInfoResult.getString("istoragesubgroup");
            AccessLatency accessLatency = AccessLatency.valueOf(storageInfoResult.getInt("iaccessLatency"));
            RetentionPolicy retentionPolicy = RetentionPolicy.valueOf(storageInfoResult.getInt("iretentionPolicy"));
            storageInfo = new InodeStorageInformation(inode, hsmName, storageGroup, storageSubGroup, accessLatency, retentionPolicy);
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(storageInfoResult);
            SqlHelper.tryToClose(stGetStorageInfo);
            throw throwable;
        }
        SqlHelper.tryToClose(storageInfoResult);
        SqlHelper.tryToClose(stGetStorageInfo);
        return storageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInodeFromCache(Connection dbConnection, String path) throws SQLException {
        String inodeString = null;
        PreparedStatement stGetInodeFromCache = null;
        ResultSet getInodeFromCacheResultSet = null;
        try {
            stGetInodeFromCache = dbConnection.prepareStatement(sqlGetInodeFromCache);
            stGetInodeFromCache.setString(1, path);
            getInodeFromCacheResultSet = stGetInodeFromCache.executeQuery();
            if (getInodeFromCacheResultSet.next()) {
                inodeString = getInodeFromCacheResultSet.getString("ipnfsid");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(getInodeFromCacheResultSet);
            SqlHelper.tryToClose(stGetInodeFromCache);
            throw throwable;
        }
        SqlHelper.tryToClose(getInodeFromCacheResultSet);
        SqlHelper.tryToClose(stGetInodeFromCache);
        return inodeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getPathFromCache(Connection dbConnection, FsInode inode) throws SQLException {
        String path = null;
        PreparedStatement stGetPathFromCache = null;
        ResultSet getPathFromCacheResultSet = null;
        try {
            stGetPathFromCache = dbConnection.prepareStatement(sqlGetPathFromCache);
            stGetPathFromCache.setString(1, inode.toString());
            getPathFromCacheResultSet = stGetPathFromCache.executeQuery();
            if (getPathFromCacheResultSet.next()) {
                path = getPathFromCacheResultSet.getString("ipath");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(getPathFromCacheResultSet);
            SqlHelper.tryToClose(stGetPathFromCache);
            throw throwable;
        }
        SqlHelper.tryToClose(getPathFromCacheResultSet);
        SqlHelper.tryToClose(stGetPathFromCache);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInodeChecksum(Connection dbConnection, FsInode inode, int type, String value) throws SQLException {
        PreparedStatement stSetInodeChecksum = null;
        try {
            stSetInodeChecksum = dbConnection.prepareStatement(sqlSetInodeChecksum);
            stSetInodeChecksum.setString(1, inode.toString());
            stSetInodeChecksum.setInt(2, type);
            stSetInodeChecksum.setString(3, value);
            stSetInodeChecksum.executeUpdate();
        }
        finally {
            SqlHelper.tryToClose(stSetInodeChecksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInodeChecksum(Connection dbConnection, FsInode inode, int type) throws SQLException {
        String checksum = null;
        PreparedStatement stGetInodeChecksum = null;
        ResultSet getGetInodeChecksumResultSet = null;
        try {
            stGetInodeChecksum = dbConnection.prepareStatement(sqlGetInodeChecksum);
            stGetInodeChecksum.setString(1, inode.toString());
            stGetInodeChecksum.setInt(2, type);
            getGetInodeChecksumResultSet = stGetInodeChecksum.executeQuery();
            if (getGetInodeChecksumResultSet.next()) {
                checksum = getGetInodeChecksumResultSet.getString("isum");
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(getGetInodeChecksumResultSet);
            SqlHelper.tryToClose(stGetInodeChecksum);
            throw throwable;
        }
        SqlHelper.tryToClose(getGetInodeChecksumResultSet);
        SqlHelper.tryToClose(stGetInodeChecksum);
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInodeChecksum(Connection dbConnection, FsInode inode, int type) throws SQLException {
        PreparedStatement stRemoveInodeChecksum = null;
        try {
            if (type >= 0) {
                stRemoveInodeChecksum = dbConnection.prepareStatement(sqlRemoveInodeChecksum);
                stRemoveInodeChecksum.setInt(2, type);
            } else {
                stRemoveInodeChecksum = dbConnection.prepareStatement(sqlRemoveInodeAllChecksum);
            }
            stRemoveInodeChecksum.setString(1, inode.toString());
            stRemoveInodeChecksum.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(stRemoveInodeChecksum);
            throw throwable;
        }
        SqlHelper.tryToClose(stRemoveInodeChecksum);
    }

    FsInode path2inode(Connection dbConnection, FsInode root, String path) throws SQLException, IOHimeraFsException {
        String f;
        File pathFile = new File(path);
        ArrayList<String> pathElemts = new ArrayList<String>();
        do {
            String fileName;
            if ((fileName = pathFile.getName()).length() == 0) continue;
            pathElemts.add(pathFile.getName());
        } while ((pathFile = pathFile.getParentFile()) != null);
        FsInode parentInode = root;
        FsInode inode = root;
        for (int i = pathElemts.size(); i > 0 && (inode = this.inodeOf(dbConnection, parentInode, f = (String)pathElemts.get(i - 1))) != null; --i) {
            Stat s = this.stat(dbConnection, inode);
            if (UnixPermission.getType(s.getMode()) == 40960) {
                int n;
                byte[] b = new byte[(int)s.getSize()];
                String link = new String(b, 0, n = this.read(dbConnection, inode, 0, 0L, b, 0, b.length));
                if (link.charAt(0) == File.separatorChar) {
                    parentInode = new FsInode(parentInode.getFs(), "000000000000000000000000000000000000");
                }
                inode = this.path2inode(dbConnection, parentInode, link);
            }
            parentInode = inode;
        }
        return inode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ACE> getACL(Connection dbConnection, FsInode inode) throws SQLException {
        ArrayList<ACE> acl = new ArrayList<ACE>();
        PreparedStatement stGetAcl = null;
        ResultSet rs = null;
        try {
            stGetAcl = dbConnection.prepareStatement(sqlGetACL);
            stGetAcl.setString(1, inode.toString());
            rs = stGetAcl.executeQuery();
            while (rs.next()) {
                int type = rs.getInt("type");
                acl.add(new ACE(type == 0 ? AceType.ACCESS_ALLOWED_ACE_TYPE : AceType.ACCESS_DENIED_ACE_TYPE, rs.getInt("flags"), rs.getInt("access_msk"), Who.valueOf(rs.getInt("who")), rs.getInt("who_id"), rs.getString("address_msk")));
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(rs);
            SqlHelper.tryToClose(stGetAcl);
            throw throwable;
        }
        SqlHelper.tryToClose(rs);
        SqlHelper.tryToClose(stGetAcl);
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setACL(Connection dbConnection, FsInode inode, List<ACE> acl) throws SQLException {
        PreparedStatement stAddACL;
        PreparedStatement stDeleteACL;
        block4: {
            stDeleteACL = null;
            stAddACL = null;
            stDeleteACL = dbConnection.prepareStatement(sqlDeleteACL);
            stDeleteACL.setString(1, inode.toString());
            stDeleteACL.executeUpdate();
            if (!acl.isEmpty()) break block4;
            SqlHelper.tryToClose(stDeleteACL);
            SqlHelper.tryToClose(stAddACL);
            return;
        }
        try {
            stAddACL = dbConnection.prepareStatement(sqlAddACL);
            int type = inode.isDirectory() ? 0 : 1;
            int order = 0;
            for (ACE ace : acl) {
                stAddACL.setString(1, inode.toString());
                stAddACL.setInt(2, type);
                stAddACL.setInt(3, ace.getType().getValue());
                stAddACL.setInt(4, ace.getFlags());
                stAddACL.setInt(5, ace.getAccessMsk());
                stAddACL.setInt(6, ace.getWho().getValue());
                stAddACL.setInt(7, ace.getWhoID());
                stAddACL.setString(8, ace.getAddressMsk());
                stAddACL.setInt(9, order);
                stAddACL.addBatch();
                ++order;
            }
            stAddACL.executeBatch();
            this.setFileCTime(dbConnection, inode, 0, System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(stDeleteACL);
            SqlHelper.tryToClose(stAddACL);
            throw throwable;
        }
        SqlHelper.tryToClose(stDeleteACL);
        SqlHelper.tryToClose(stAddACL);
    }

    public boolean isDuplicatedKeyError(String sqlState) {
        return sqlState.equals("23505");
    }

    public boolean isForeignKeyError(String sqlState) {
        return sqlState.equals("23503");
    }

    static FsSqlDriver getDriverInstance(String dialect) {
        FsSqlDriver driver = null;
        String dialectDriverClass = "org.dcache.chimera." + dialect + "FsSqlDriver";
        try {
            driver = (FsSqlDriver)Class.forName(dialectDriverClass).newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException e) {
            _log.info(dialectDriverClass + " not found, using default FsSQLDriver.");
            driver = new FsSqlDriver();
        }
        return driver;
    }
}

