/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.examples.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.examples.cli.FsFactory;
import org.dcache.chimera.examples.cli.Readtag;

public class Writetag {
    public static void main(String[] args) throws Exception {
        byte[] data;
        int programArgc = args.length - 5;
        if (programArgc < 2 || programArgc > 3) {
            System.err.println("Usage : " + Readtag.class.getName() + " " + "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path> <tag> [<data>]");
            System.exit(4);
        }
        FileSystemProvider fs = FsFactory.createFileSystem(args);
        FsInode inode = fs.path2inode(args[5]);
        String tag = args[6];
        try {
            fs.statTag(inode, tag);
        }
        catch (FileNotFoundHimeraFsException fnf) {
            fs.createTag(inode, tag);
        }
        byte[] byArray = data = programArgc == 2 ? Writetag.toByteArray(System.in) : Writetag.newLineTerminated(args[7]).getBytes();
        if (data.length > 0) {
            fs.setTag(inode, tag, data, 0, data.length);
        }
    }

    private static String newLineTerminated(String unknown) {
        return unknown.endsWith("\n") ? unknown : unknown + "\n";
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Writetag.copy(in, out);
        return out.toByteArray();
    }
}

