/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.PUTFH4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.vfs.Inode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationPUTFH
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationPUTFH.class);

    public OperationPUTFH(nfs_argop4 args) {
        super(args, 22);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        PUTFH4res res = result.opputfh;
        try {
            context.currentInode(new Inode(this._args.opputfh.object.value));
            _log.debug("NFS Request  PUTFH4 current: {}", context.currentInode());
            res.status = 0;
        }
        catch (IllegalArgumentException iae) {
            res.status = 10001;
        }
    }
}

