/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.dcache.chimera.nfs.v4.xdr.netaddr4;
import org.dcache.chimera.nfs.v4.xdr.nfsv4_1_file_layout_ds_addr4;
import org.dcache.utils.net.InetSocketAddresses;

public class FileIoDevice {
    private final InetSocketAddress[] _ds_list;
    private final int[] _stripe_indices;

    public FileIoDevice(nfsv4_1_file_layout_ds_addr4 addr) throws UnknownHostException {
        int i;
        this._stripe_indices = new int[addr.nflda_stripe_indices.length];
        for (i = 0; i < this._stripe_indices.length; ++i) {
            this._stripe_indices[i] = addr.nflda_stripe_indices[i].value;
        }
        this._ds_list = new InetSocketAddress[addr.nflda_multipath_ds_list.length];
        block1: for (i = 0; i < this._ds_list.length; ++i) {
            for (netaddr4 na : addr.nflda_multipath_ds_list[i].value) {
                if (!na.na_r_netid.equals("tcp")) continue;
                this._ds_list[i] = InetSocketAddresses.forUaddrString(na.na_r_addr);
                continue block1;
            }
        }
    }

    public InetSocketAddress of(long pattern_offset, int unit_size, long offset, int len, int first_stripe_index) {
        long relative_offset = offset - pattern_offset;
        int suIndex = (int)Math.floor(relative_offset / (long)unit_size);
        int index = (suIndex + first_stripe_index) % this._stripe_indices.length;
        return this._ds_list[this._stripe_indices[index]];
    }

    public String toString() {
        return Arrays.toString(this._ds_list);
    }
}

