/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.glassfish.gmbal.generic.Algorithms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DprintUtil {
    private static final boolean USE_LOGGER = false;
    private final String sourceClassName;
    private final String loggerName;
    private final ThreadLocal<Stack<String>> currentMethod = new ThreadLocal<Stack<String>>(){

        @Override
        public Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    private static Map<String, DprintUtil> dpuMap = new WeakHashMap<String, DprintUtil>();

    public static DprintUtil getDprintUtil(Class<?> cls) {
        String cname = cls.getName();
        DprintUtil result = dpuMap.get(cname);
        if (result == null) {
            result = new DprintUtil(cls);
            dpuMap.put(cname, result);
        }
        return result;
    }

    private DprintUtil(Class selfClass) {
        this.sourceClassName = DprintUtil.compressClassName(selfClass.getName());
        this.loggerName = null;
    }

    private static String compressClassName(String name2) {
        String prefix = "org.glassfish.gmbal.";
        if (name2.startsWith(prefix)) {
            return "(GMBAL)." + name2.substring(prefix.length());
        }
        return name2;
    }

    public synchronized void dprint(String msg) {
        String prefix = "(" + Thread.currentThread().getName() + "): ";
        System.out.println(prefix + this.sourceClassName + msg);
    }

    private String makeString(Object ... args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (Object obj : args) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(Algorithms.convertToString(obj));
        }
        sb.append(')');
        return sb.toString();
    }

    public void enter(String mname, Object ... args) {
        this.currentMethod.get().push(mname);
        String str = this.makeString(args);
        this.dprint("." + mname + "->" + str);
    }

    public void info(Object ... args) {
        String mname = this.currentMethod.get().peek();
        String str = this.makeString(args);
        this.dprint("." + mname + "::" + str);
    }

    public void exit() {
        String mname = this.currentMethod.get().peek();
        this.dprint("." + mname + "<-");
        this.currentMethod.get().pop();
    }

    public void exit(Object retVal) {
        String mname = this.currentMethod.get().peek();
        this.dprint("." + mname + "<-(" + retVal + ")");
        this.currentMethod.get().pop();
    }
}

