/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import dmg.util.command.Argument;
import dmg.util.command.Option;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AnnotatedCommandUtils {
    private static final Function<Field, Integer> GET_ARGUMENT_INDEX = new Function<Field, Integer>(){

        public Integer apply(Field field) {
            return field.getAnnotation(Argument.class).index();
        }
    };
    private static final Function<Field, String> GET_OPTION_NAME = new Function<Field, String>(){

        public String apply(Field field) {
            return field.getAnnotation(Option.class).name();
        }
    };

    private AnnotatedCommandUtils() {
    }

    public static Multimap<String, Field> getOptionsByCategory(Class<?> clazz) {
        TreeMultimap options = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.natural().onResultOf(GET_OPTION_NAME));
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                options.put((Object)option.category(), (Object)field);
            }
        }
        return options;
    }

    public static List<Field> getArguments(Class<?> clazz) {
        ArrayList arguments = Lists.newArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Argument.class)) continue;
                arguments.add(field);
            }
        }
        Collections.sort(arguments, Ordering.natural().onResultOf(GET_ARGUMENT_INDEX));
        return arguments;
    }
}

