/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.cli;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import dmg.util.command.Command;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.dcache.util.cli.AnnotatedCommandExecutor;
import org.dcache.util.cli.CommandExecutor;
import org.dcache.util.cli.CommandScanner;

public class AnnotatedCommandScanner
implements CommandScanner {
    private static final TypeToken<Callable<? extends Serializable>> EXPECTED_TYPE = new TypeToken<Callable<? extends Serializable>>(){};

    private Class<? extends Callable<? extends Serializable>> cast(Class<?> clazz) {
        if (EXPECTED_TYPE.isAssignableFrom(clazz)) {
            return clazz.asSubclass(Callable.class);
        }
        throw new RuntimeException("This is a bug. Please notify support@dcache.org (" + clazz + " does not implement Callable<? extends Serializable>).");
    }

    @Override
    public Map<List<String>, ? extends CommandExecutor> scan(Object obj) {
        HashMap commands = Maps.newHashMap();
        for (Class<?> containerClass = obj.getClass(); containerClass != null; containerClass = containerClass.getSuperclass()) {
            Class<?>[] classes;
            for (Class<?> commandClass : classes = containerClass.getDeclaredClasses()) {
                Command command = commandClass.getAnnotation(Command.class);
                if (command == null || commandClass.isInterface() || !Callable.class.isAssignableFrom(commandClass)) continue;
                try {
                    Constructor<? extends Callable<? extends Serializable>> constructor = this.cast(commandClass).getDeclaredConstructor(commandClass.getDeclaringClass());
                    constructor.setAccessible(true);
                    commands.put(Arrays.asList(command.name().split(" ")), new AnnotatedCommandExecutor(obj, command, constructor));
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("This is a bug. Please notify support@dcache.org.", e);
                }
            }
        }
        return commands;
    }
}

