/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.cli;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.command.Command;
import dmg.util.command.HelpFormat;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Callable;
import jline.ANSIBuffer;
import jline.ConsoleReader;
import org.dcache.util.Args;
import org.dcache.util.cli.CommandInterpreter;

public abstract class ShellApplication
implements Closeable {
    protected final ConsoleReader console = new ConsoleReader();
    private final CommandInterpreter commandInterpreter = new CommandInterpreter(this);
    private final boolean isAnsiSupported;
    private final boolean hasConsole;

    public ShellApplication() throws Exception {
        this.commandInterpreter.addCommandListener(this.commandInterpreter.new CommandInterpreter.HelpCommands());
        this.hasConsole = System.console() != null;
        this.isAnsiSupported = this.console.getTerminal().isANSISupported() && this.hasConsole;
    }

    protected void start(Args args) throws Throwable {
        if (args.hasOption("h")) {
            System.out.println("Usage: " + this.getCommandName() + " [-e] [-f=<file>]|[-]|[COMMAND]");
            System.out.println();
            System.out.println("Use '" + this.getCommandName() + " help' for an overview of available commands.");
            System.exit(0);
        }
        if (args.hasOption("f")) {
            try (FileInputStream in = new FileInputStream(args.getOption("f"));){
                this.execute(new BufferedInputStream(in), System.out, args.hasOption("e"));
            }
        } else if (args.argc() == 1 && args.argv(0).equals("-")) {
            this.execute(System.in, System.out, args.hasOption("e"));
        } else if (args.argc() > 0) {
            this.execute(args);
        } else if (!this.hasConsole) {
            this.execute(System.in, System.out, args.hasOption("e"));
        } else {
            this.console();
        }
    }

    protected abstract String getCommandName();

    public void execute(InputStream in, final PrintStream out, final boolean echo) throws IOException {
        CharStreams.readLines((Readable)new InputStreamReader(in, Charsets.US_ASCII), (LineProcessor)new LineProcessor<Object>(){

            public boolean processLine(String line) throws IOException {
                try {
                    Args args;
                    if (echo) {
                        out.println(line);
                    }
                    if ((args = new Args((CharSequence)line)).argc() == 0) {
                        return true;
                    }
                    String s = Objects.toString(ShellApplication.this.commandInterpreter.command(args), null);
                    if (!Strings.isNullOrEmpty((String)s)) {
                        out.println(s);
                    }
                    return true;
                }
                catch (CommandException e) {
                    throw new IOException(e);
                }
            }

            public Object getResult() {
                return null;
            }
        });
    }

    public void execute(Args args) throws Throwable {
        String out;
        if (args.argc() == 0) {
            return;
        }
        try {
            if (this.isAnsiSupported && args.argc() > 0 && args.argv(0).equals("help")) {
                args.shift();
                args = new Args((CharSequence)("help -format=" + (Object)((Object)HelpFormat.ANSI) + " " + args.toString()));
            }
            try {
                out = Objects.toString(this.commandInterpreter.command(args), null);
            }
            catch (CommandThrowableException e) {
                throw e.getCause();
            }
        }
        catch (CommandSyntaxException e) {
            ANSIBuffer sb = new ANSIBuffer();
            sb.red("Syntax error: " + e.getMessage() + "\n");
            String help = e.getHelpText();
            if (help != null) {
                sb.append(help);
            }
            out = sb.toString(this.isAnsiSupported);
        }
        catch (CommandExitException e) {
            throw e;
        }
        catch (Exception e) {
            out = new ANSIBuffer().red(e.getMessage()).toString(this.isAnsiSupported);
        }
        if (!Strings.isNullOrEmpty((String)out)) {
            this.console.printString(out);
            if (out.charAt(out.length() - 1) != '\n') {
                this.console.printNewline();
            }
            this.console.flushConsole();
        }
    }

    public void console() throws Throwable {
        this.onInteractiveStart();
        try {
            while (true) {
                String prompt;
                String str;
                if ((str = this.console.readLine(prompt = new ANSIBuffer().bold(this.getPrompt()).toString(this.isAnsiSupported))) == null) {
                    this.console.printNewline();
                    break;
                }
                this.execute(new Args((CharSequence)str));
            }
        }
        catch (CommandExitException commandExitException) {
            // empty catch block
        }
    }

    protected void onInteractiveStart() throws IOException {
        this.console.printString("Type 'help' for help on commands.\n");
        this.console.printString("Type 'exit' or Ctrl+D to exit.\n");
    }

    protected String getPrompt() {
        return "# ";
    }

    @Override
    public void close() throws IOException {
    }

    @Command(name="exit", hint="exit the shell")
    public class ExitComamnd
    implements Callable<Serializable> {
        @Override
        public Serializable call() throws CommandExitException {
            throw new CommandExitException();
        }
    }
}

