/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import dmg.util.CommandException;
import dmg.util.CommandSyntaxException;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.HelpFormat;
import dmg.util.command.Option;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.dcache.util.Args;
import org.dcache.util.cli.AnnotatedCommandScanner;
import org.dcache.util.cli.CommandExecutor;
import org.dcache.util.cli.CommandScanner;

public class CommandInterpreter {
    private final CommandEntry _rootEntry = new CommandEntry("");
    private ImmutableList<CommandScanner> _scanners = ImmutableList.of((Object)new AnnotatedCommandScanner());
    private ImmutableSet<Object> _commandListeners = ImmutableSet.of();

    public CommandInterpreter() {
        this.addCommandListener(this);
    }

    public CommandInterpreter(Object commandListener) {
        this.addCommandListener(commandListener);
    }

    protected synchronized void addCommandScanner(CommandScanner scanner) {
        this._scanners = ImmutableList.builder().addAll(this._scanners).add((Object)scanner).build();
        for (Object commandListener : this._commandListeners) {
            this.addCommands(scanner.scan(commandListener));
        }
    }

    public final synchronized void addCommandListener(Object commandListener) {
        for (CommandScanner scanner : this._scanners) {
            this.addCommands(scanner.scan(commandListener));
        }
        this._commandListeners = ImmutableSet.builder().addAll(this._commandListeners).add(commandListener).build();
    }

    private void addCommands(Map<List<String>, ? extends CommandExecutor> commands) {
        for (Map.Entry<List<String>, ? extends CommandExecutor> entry : commands.entrySet()) {
            CommandEntry currentEntry = this._rootEntry.getOrCreate(entry.getKey());
            if (currentEntry.hasCommand()) {
                throw new IllegalArgumentException("Conflicting implementations of shell command '" + Joiner.on((String)" ").join((Iterable)entry.getKey()) + "': " + currentEntry.getCommand() + " and " + entry.getValue());
            }
            currentEntry.setCommand(entry.getValue());
        }
    }

    public Serializable command(Args args) throws CommandException {
        CommandEntry ce;
        CommandEntry entry = this._rootEntry;
        CommandEntry lastAcl = null;
        StringBuilder path = new StringBuilder();
        while (args.argc() > 0 && (ce = entry.get(args.argv(0))) != null) {
            if (ce.hasACLs()) {
                lastAcl = ce;
            }
            path.append(ce.getName()).append(' ');
            entry = ce;
            args.shift();
        }
        String[] acls = lastAcl == null ? new String[]{} : lastAcl.getACLs();
        try {
            return this.doExecute(entry, args, acls);
        }
        catch (CommandSyntaxException e) {
            if (e.getHelpText() == null) {
                StringBuilder sb = new StringBuilder();
                entry.dumpHelpHint(path.toString(), sb, HelpFormat.PLAIN);
                e.setHelpText(sb.toString());
            }
            throw e;
        }
    }

    protected Serializable doExecute(CommandEntry entry, Args args, String[] acls) throws CommandException {
        return entry.execute(args);
    }

    public String getHelp(HelpFormat format, String ... command) {
        String word;
        CommandEntry ce;
        CommandEntry entry = this._rootEntry;
        StringBuilder path = new StringBuilder();
        String[] arr$ = command;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (ce = entry.get(word = arr$[i$])) != null; ++i$) {
            path.append(ce.getName()).append(' ');
            entry = ce;
        }
        String help = entry.getFullHelp(format);
        if (help == null) {
            StringBuilder sb = new StringBuilder();
            entry.dumpHelpHint(path.toString(), sb, format);
            help = sb.toString();
        }
        return help;
    }

    public class HelpCommands {

        @Command(name="help", hint="display help pages")
        public class HelpCommand
        implements Callable<String> {
            @Option(name="format", usage="Output format.")
            HelpFormat format;
            @Argument(valueSpec="COMMAND", required=false, usage="When invoked with a specific command, detailed help for that command is displayed. When invoked with a partial command or without an argument, a summary of all matching commands is shown.")
            String[] command = new String[0];

            @Override
            public String call() {
                return CommandInterpreter.this.getHelp(this.format == null ? HelpFormat.PLAIN : this.format, this.command);
            }
        }
    }

    protected static class CommandEntry {
        private ImmutableSortedMap<String, CommandEntry> _suffixes = ImmutableSortedMap.of();
        private final String _name;
        private CommandExecutor _commandExecutor;

        CommandEntry(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void put(String str, CommandEntry e) {
            this._suffixes = ImmutableSortedMap.naturalOrder().putAll(this._suffixes).put((Object)str, (Object)e).build();
        }

        public CommandEntry get(String str) {
            return (CommandEntry)this._suffixes.get((Object)str);
        }

        public CommandEntry getOrCreate(String name) {
            CommandEntry entry = (CommandEntry)this._suffixes.get((Object)name);
            if (entry == null) {
                entry = new CommandEntry(name);
                this.put(name, entry);
            }
            return entry;
        }

        public CommandEntry getOrCreate(List<String> names) {
            CommandEntry entry = this;
            for (String name : names) {
                entry = entry.getOrCreate(name);
            }
            return entry;
        }

        public void setCommand(CommandExecutor commandExecutor) {
            this._commandExecutor = commandExecutor;
        }

        public CommandExecutor getCommand() {
            return this._commandExecutor;
        }

        boolean hasCommand() {
            return this._commandExecutor != null;
        }

        public boolean hasACLs() {
            return this._commandExecutor != null && this._commandExecutor.hasACLs();
        }

        public void dumpHelpHint(String top, StringBuilder sb, HelpFormat format) {
            String hint;
            if (this._commandExecutor != null && (hint = this._commandExecutor.getHelpHint(format)) != null) {
                sb.append(top).append(hint).append("\n");
            }
            for (CommandEntry ce : this._suffixes.values()) {
                ce.dumpHelpHint(top + ce.getName() + " ", sb, format);
            }
        }

        public Serializable execute(Args arguments) throws CommandException {
            if (this._commandExecutor == null) {
                throw new CommandSyntaxException("Command not found");
            }
            return this._commandExecutor.execute(arguments);
        }

        public String getFullHelp(HelpFormat format) {
            return this._commandExecutor == null ? null : this._commandExecutor.getFullHelp(format);
        }

        public String[] getACLs() {
            return this._commandExecutor == null ? new String[]{} : this._commandExecutor.getACLs();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry : ").append(this.getName());
            for (String key : this._suffixes.keySet()) {
                sb.append(" -> ").append(key).append("\n");
            }
            return sb.toString();
        }
    }
}

