/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import dmg.util.command.AnnotatedCommandHelpPrinter;
import dmg.util.command.AnnotatedCommandUtils;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.Option;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.dcache.commons.util.Strings;

public abstract class TextHelpPrinter
implements AnnotatedCommandHelpPrinter {
    private static final Pattern VALUESPEC_SEPARATOR = Pattern.compile("(?<=[\\[\\]|]|\\.{3})|(?=[\\[\\]|]|\\.{3})|(?<=[^A-Z])(?=[A-Z])|(?<=[A-Z])(?=[^A-Z])");
    private static final int WIDTH = 72;
    private static final Predicate<? super Field> shouldBeDocumented = new Predicate<Field>(){

        public boolean apply(Field field) {
            Argument argument = field.getAnnotation(Argument.class);
            return argument != null && (!argument.usage().isEmpty() || !argument.required());
        }
    };

    private <T> Iterable<String> literal(T[] values) {
        return Iterables.transform(Arrays.asList(values), (Function)new Function<T, String>(){

            public String apply(T s) {
                return TextHelpPrinter.this.literal(s.toString());
            }
        });
    }

    protected String valuespec(String valuespec) {
        StringBuilder out = new StringBuilder();
        Iterator i$ = Splitter.on((Pattern)VALUESPEC_SEPARATOR).split((CharSequence)valuespec).iterator();
        block9: while (i$.hasNext()) {
            String s;
            switch (s = (String)i$.next()) {
                case "[": 
                case "]": 
                case "|": 
                case "...": {
                    out.append(s);
                    continue block9;
                }
            }
            if (CharMatcher.JAVA_UPPER_CASE.matchesAllOf((CharSequence)s)) {
                out.append(this.value(s));
                continue;
            }
            out.append(this.literal(s));
        }
        return out.toString();
    }

    private String getMetaVar(Class<?> type, Option option) {
        if (!option.metaVar().isEmpty()) {
            return this.value(option.metaVar().toUpperCase());
        }
        if (!option.valueSpec().isEmpty()) {
            return this.valuespec(option.valueSpec());
        }
        if (option.values().length > 0) {
            return Joiner.on((String)"|").join(this.literal((T[])option.values()));
        }
        if (type.isEnum()) {
            return Joiner.on((String)"|").join(this.literal(type.getEnumConstants()));
        }
        return this.value(type.getSimpleName().toUpperCase());
    }

    private String getMetaVar(Field field, Argument argument) {
        if (!argument.valueSpec().isEmpty()) {
            return this.valuespec(argument.valueSpec());
        }
        if (!argument.metaVar().isEmpty()) {
            return this.value(argument.metaVar().toUpperCase());
        }
        return this.value(field.getName().toUpperCase());
    }

    private String getSignature(Class<?> clazz) {
        StringBuilder signature = new StringBuilder();
        Multimap<String, Field> options = AnnotatedCommandUtils.getOptionsByCategory(clazz);
        for (Field field : options.values()) {
            Class<?> type = field.getType();
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            if (!type.isArray()) {
                if (!option.required()) {
                    signature.append("[");
                }
                signature.append(this.literal("-" + option.name()));
                if (!Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
                    signature.append("=").append(this.getMetaVar(type, option));
                }
                if (!option.required()) {
                    signature.append("]");
                }
            } else if (option.separator().isEmpty()) {
                if (!option.required()) {
                    signature.append("[");
                }
                signature.append(this.literal("-" + option.name()));
                signature.append("=").append(this.getMetaVar(type.getComponentType(), option));
                if (!option.required()) {
                    signature.append("]");
                }
                signature.append(this.value("..."));
            } else {
                if (!option.required()) {
                    signature.append("[");
                }
                String metaVar = this.getMetaVar(type.getComponentType(), option);
                signature.append(this.literal("-" + option.name()));
                signature.append("=").append(metaVar);
                signature.append("[").append(option.separator()).append(metaVar).append("]").append(this.value("..."));
                if (!option.required()) {
                    signature.append("]").append(this.value("..."));
                }
            }
            signature.append(" ");
        }
        for (Field field : AnnotatedCommandUtils.getArguments(clazz)) {
            Argument argument = field.getAnnotation(Argument.class);
            String metaVar = this.getMetaVar(field, argument);
            if (argument.required()) {
                signature.append(metaVar);
            } else {
                signature.append("[").append(metaVar).append("]");
            }
            if (field.getType().isArray()) {
                signature.append(this.value("..."));
            }
            signature.append(" ");
        }
        return signature.toString();
    }

    private String getShortSignature(Class<?> clazz) {
        StringBuilder signature = new StringBuilder();
        if (!AnnotatedCommandUtils.getOptionsByCategory(clazz).isEmpty()) {
            signature.append("[OPTIONS] ");
        }
        for (Field field : AnnotatedCommandUtils.getArguments(clazz)) {
            Argument argument = field.getAnnotation(Argument.class);
            String metaVar = this.getMetaVar(field, argument);
            if (argument.required()) {
                signature.append(metaVar);
            } else {
                signature.append("[").append(metaVar).append("]");
            }
            if (field.getType().isArray()) {
                signature.append(this.value("..."));
            }
            signature.append(" ");
        }
        return signature.toString();
    }

    @Override
    public String getHelpHint(Command command, Class<?> clazz) {
        String hint = command.hint().isEmpty() ? "" : "# " + command.hint();
        String signature = this.getSignature(clazz);
        if (this.plainLength(signature) + this.plainLength(hint) > 78) {
            signature = this.getShortSignature(clazz);
        }
        return (signature.isEmpty() ? "" : signature + " ") + hint;
    }

    @Override
    public String getHelp(Object instance) {
        Multimap<String, Field> options;
        Class<?> clazz = instance.getClass();
        Command command = clazz.getAnnotation(Command.class);
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println(this.heading("NAME"));
        writer.append("       ").append(this.literal(command.name()));
        if (!command.hint().isEmpty()) {
            writer.append(" -- ").append(command.hint());
        }
        writer.println();
        writer.println();
        writer.println(this.heading("SYNOPSIS"));
        writer.append(Strings.wrap((String)"       ", (String)(this.literal(command.name()) + " " + this.getSignature(clazz)), (int)72));
        writer.println();
        if (!command.description().isEmpty()) {
            writer.println(this.heading("DESCRIPTION"));
            writer.append(Strings.wrap((String)"       ", (String)command.description(), (int)72));
        }
        writer.println();
        List<Field> arguments = AnnotatedCommandUtils.getArguments(clazz);
        if (!arguments.isEmpty() && Iterables.any(arguments, shouldBeDocumented)) {
            writer.println(this.heading("ARGUMENTS"));
            for (Field field : arguments) {
                Argument argument = field.getAnnotation(Argument.class);
                writer.append("       ").println(this.getMetaVar(field, argument));
                String help = argument.usage();
                if (!argument.required()) {
                    help = Joiner.on((char)' ').join((Object)help, (Object)this.getDefaultDescription(instance, field), new Object[0]);
                }
                if (help.isEmpty()) continue;
                writer.append(Strings.wrap((String)"              ", (String)help, (int)65));
            }
            writer.println();
        }
        if (!(options = AnnotatedCommandUtils.getOptionsByCategory(clazz)).isEmpty()) {
            writer.println(this.heading("OPTIONS"));
            for (Map.Entry category : options.asMap().entrySet()) {
                if (!((String)category.getKey()).isEmpty()) {
                    writer.append("       ").println(this.heading((String)category.getKey() + ":"));
                }
                for (Field field : (Collection)category.getValue()) {
                    Class<?> type = field.getType();
                    Option option = field.getAnnotation(Option.class);
                    writer.append("       ").append(this.literal("  -" + option.name()));
                    if (!type.isArray()) {
                        if (!Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
                            writer.append("=").append(this.getMetaVar(type, option));
                        }
                    } else if (option.separator().isEmpty()) {
                        writer.append("=").append(this.getMetaVar(type.getComponentType(), option));
                        writer.append(this.value("..."));
                    } else {
                        String metaVar = this.getMetaVar(type.getComponentType(), option);
                        writer.append("=").append(metaVar);
                        writer.append("[").append(option.separator()).append(metaVar).append("]");
                        writer.append(this.value("..."));
                    }
                    writer.println();
                    String usage = option.usage();
                    if (!option.required()) {
                        usage = Joiner.on((char)' ').join((Object)usage, (Object)this.getDefaultDescription(instance, field), new Object[0]);
                    }
                    if (usage.isEmpty()) continue;
                    writer.append(Strings.wrap((String)"              ", (String)usage, (int)65));
                }
            }
        }
        writer.flush();
        return out.toString();
    }

    private String getDefaultDescription(Object instance, Field field) {
        try {
            field.setAccessible(true);
            Object value = field.get(instance);
            if (value != null && this.hasDefaultDescription(field.getType(), value)) {
                return "Defaults to " + this.literal(value) + '.';
            }
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return "";
    }

    private String literal(Object value) {
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            StringBuilder s = new StringBuilder();
            if (length > 0) {
                s.append(this.literal(Array.get(value, 0).toString()));
                for (int i = 1; i < length; ++i) {
                    s.append(' ').append(this.literal(Array.get(value, i).toString()));
                }
            }
            return s.toString();
        }
        return this.literal(value.toString());
    }

    private boolean hasDefaultDescription(Class<?> type, Object value) {
        return !(type.isArray() ? Array.getLength(value) == 0 : (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) && (Boolean)value == false);
    }

    protected int plainLength(String s) {
        return s.length();
    }

    protected abstract String value(String var1);

    protected abstract String literal(String var1);

    protected abstract String heading(String var1);
}

