/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.cli;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import dmg.util.CommandException;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.command.AnnotatedCommandHelpPrinter;
import dmg.util.command.AnsiHelpPrinter;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.CommandLine;
import dmg.util.command.HelpFormat;
import dmg.util.command.Option;
import dmg.util.command.PlainHelpPrinter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dcache.util.Args;
import org.dcache.util.cli.CommandExecutor;

public class AnnotatedCommandExecutor
implements CommandExecutor {
    private static final Function<Handler, Integer> GET_MAX_ARGS = new Function<Handler, Integer>(){

        public Integer apply(Handler handler) {
            return handler.getMaxArguments();
        }
    };
    private static final ImmutableMap<HelpFormat, AnnotatedCommandHelpPrinter> HELP_PRINTERS = ImmutableMap.builder().put((Object)HelpFormat.PLAIN, (Object)new PlainHelpPrinter()).put((Object)HelpFormat.ANSI, (Object)new AnsiHelpPrinter()).build();
    private static final Joiner AS_COMMA_LIST = Joiner.on((String)", ");
    private final Object _parent;
    private final Command _command;
    private final Constructor<? extends Callable<? extends Serializable>> _constructor;
    private final List<Handler> _handlers;

    public AnnotatedCommandExecutor(Object parent, Command command, Constructor<? extends Callable<? extends Serializable>> constructor) {
        this._parent = parent;
        this._command = command;
        this._constructor = constructor;
        this._handlers = AnnotatedCommandExecutor.createFieldHandlers(command, this._constructor.getDeclaringClass());
    }

    @Override
    public boolean hasACLs() {
        return this._command.acl().length > 0;
    }

    @Override
    public String[] getACLs() {
        return this._command.acl();
    }

    private AnnotatedCommandHelpPrinter getHelpPrinter(HelpFormat format) {
        AnnotatedCommandHelpPrinter printer = (AnnotatedCommandHelpPrinter)HELP_PRINTERS.get((Object)format);
        if (printer == null) {
            printer = (AnnotatedCommandHelpPrinter)HELP_PRINTERS.get((Object)HelpFormat.PLAIN);
        }
        return printer;
    }

    @Override
    public String getHelpHint(HelpFormat format) {
        return this.getHelpPrinter(format).getHelpHint(this._command, this._constructor.getDeclaringClass());
    }

    @Override
    public String getFullHelp(HelpFormat format) {
        return this.getHelpPrinter(format).getHelp(this.createInstance());
    }

    @Override
    public Serializable execute(Args arguments) throws CommandException {
        Callable<? extends Serializable> command = this.createInstance();
        try {
            for (Handler handler : this._handlers) {
                handler.apply(command, arguments);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("This is a bug. Please notify support@dcache.org", e);
        }
        catch (IllegalArgumentException e) {
            throw new CommandSyntaxException(e.getMessage());
        }
        try {
            return command.call();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (RuntimeException e) {
            try {
                boolean declared = false;
                Method method = command.getClass().getMethod("call", new Class[0]);
                for (Class<?> clazz : method.getExceptionTypes()) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    declared = true;
                }
                if (!declared) {
                    throw e;
                }
                throw new CommandThrowableException(e.toString() + " from " + this._command.name(), e);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("This is a bug. Please notify support@dcache.org", nsme);
            }
        }
        catch (Exception e) {
            throw new CommandThrowableException(e.toString() + " from " + this._command.name(), e);
        }
    }

    private Callable<? extends Serializable> createInstance() {
        try {
            return this._constructor.newInstance(this._parent);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("This is a bug. Please notify support@dcache.org", e);
        }
    }

    private static Handler createFieldHandler(Field field, Option option) {
        Class<?> type = field.getType();
        if (type.isArray()) {
            MultipleChoiceValidator typeConverter = AnnotatedCommandExecutor.createTypeConverter(type.getComponentType());
            if (option.values().length > 0) {
                typeConverter = new MultipleChoiceValidator(typeConverter, Arrays.asList(option.values()));
            }
            if (option.separator().isEmpty()) {
                return new MultiValuedOptionHandler(field, typeConverter, option);
            }
            return new SplittingOptionHandler(field, typeConverter, option);
        }
        MultipleChoiceValidator typeConverter = AnnotatedCommandExecutor.createTypeConverter(type);
        if (option.values().length > 0) {
            typeConverter = new MultipleChoiceValidator(typeConverter, Arrays.asList(option.values()));
        }
        return new OptionHandler(field, typeConverter, option);
    }

    private static Handler createFieldHandler(Field field, Argument argument) {
        Class<?> type = field.getType();
        if (type.isArray()) {
            Function<String, Object> typeConverter = AnnotatedCommandExecutor.createTypeConverter(type.getComponentType());
            return new MultiValuedArgumentHandler(field, typeConverter, argument);
        }
        Function<String, Object> typeConverter = AnnotatedCommandExecutor.createTypeConverter(type);
        return new ArgumentHandler(field, typeConverter, argument);
    }

    private static Handler createFieldHandler(Command command, Field field, CommandLine commandLine) {
        Class<Object> type = field.getType();
        if (type.isAssignableFrom(Args.class)) {
            return new ArgsHandler(field);
        }
        if (type.isAssignableFrom(String.class)) {
            return new CommandLineHandler(command, field);
        }
        throw new IllegalArgumentException("CommandLine annotation is only applicable to Args and String fields");
    }

    private static List<Handler> createFieldHandlers(Command command, Class<? extends Callable<?>> clazz) {
        int maxArgs;
        HashSet<String> names = new HashSet<String>();
        ArrayList handlers = Lists.newArrayList();
        for (Class<Callable<?>> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                CommandLine commandLine;
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    handlers.add(AnnotatedCommandExecutor.createFieldHandler(field, option));
                    names.add(option.name());
                }
                if ((argument = field.getAnnotation(Argument.class)) != null) {
                    handlers.add(AnnotatedCommandExecutor.createFieldHandler(field, argument));
                }
                if ((commandLine = field.getAnnotation(CommandLine.class)) == null) continue;
                handlers.add(AnnotatedCommandExecutor.createFieldHandler(command, field, commandLine));
            }
        }
        int n = maxArgs = handlers.isEmpty() ? 0 : (Integer)Ordering.natural().max(Iterables.transform((Iterable)handlers, GET_MAX_ARGS));
        if (maxArgs < Integer.MAX_VALUE) {
            handlers.add(new MaxArgumentsHandler(maxArgs));
        }
        handlers.add(new CheckOptionsKnownHandler(names));
        return handlers;
    }

    private static Function<String, Object> createTypeConverter(Class<?> type) {
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return new BooleanTypeConverter();
        }
        if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            return new ByteTypeConverter();
        }
        if (Character.class.equals(type) || Character.TYPE.equals(type)) {
            return new CharacterTypeConverter();
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return new DoubleTypeConverter();
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return new FloatTypeConverter();
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return new IntegerTypeConverter();
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return new LongTypeConverter();
        }
        if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            return new ShortTypeConverter();
        }
        if (String.class.equals(type)) {
            return new StringTypeConverter();
        }
        if (type.isEnum()) {
            return new EnumTypeConverter(type.asSubclass(Enum.class));
        }
        if (!(type.isInterface() || type.isAnnotation() || type.isPrimitive())) {
            try {
                Method method = type.getMethod("valueOf", String.class);
                if (Modifier.isStatic(method.getModifiers())) {
                    return new ValueOfTypeConverter(method);
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            try {
                return new StringConstructorTypeConverter(type.getConstructor(String.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new RuntimeException("This is a bug. Please notify support@dcache.org. Cannot convert to type " + type);
    }

    private static class EnumTypeConverter
    implements Function<String, Object> {
        private Class<? extends Enum> _type;

        public EnumTypeConverter(Class<? extends Enum> type) {
            this._type = type;
        }

        public Object apply(String value) {
            return Enum.valueOf(this._type, value.toUpperCase());
        }
    }

    private static class ValueOfTypeConverter
    implements Function<String, Object> {
        private Method _method;

        public ValueOfTypeConverter(Method method) {
            this._method = method;
        }

        public Object apply(String value) {
            try {
                return this._method.invoke(null, value);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                Throwables.propagateIfPossible((Throwable)t);
                throw new IllegalArgumentException(t.getMessage(), t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This is a bug. Please notify support@dcache.org", e);
            }
        }
    }

    private static class StringConstructorTypeConverter
    implements Function<String, Object> {
        private Constructor<?> _constructor;

        public StringConstructorTypeConverter(Constructor<?> constructor) {
            this._constructor = constructor;
        }

        public Object apply(String value) {
            try {
                return this._constructor.newInstance(value);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                Throwables.propagateIfPossible((Throwable)t);
                throw new IllegalArgumentException(t.getMessage(), t);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("This is a bug. Please notify support@dcache.org", e);
            }
        }
    }

    private static class StringTypeConverter
    implements Function<String, Object> {
        private StringTypeConverter() {
        }

        public String apply(String value) {
            return value;
        }
    }

    private static class ShortTypeConverter
    implements Function<String, Object> {
        private ShortTypeConverter() {
        }

        public Short apply(String value) {
            return Short.valueOf(value);
        }
    }

    private static class LongTypeConverter
    implements Function<String, Object> {
        private LongTypeConverter() {
        }

        public Long apply(String value) {
            return Long.valueOf(value);
        }
    }

    private static class IntegerTypeConverter
    implements Function<String, Object> {
        private IntegerTypeConverter() {
        }

        public Integer apply(String value) {
            return Integer.valueOf(value);
        }
    }

    private static class FloatTypeConverter
    implements Function<String, Object> {
        private FloatTypeConverter() {
        }

        public Float apply(String value) {
            return Float.valueOf(value);
        }
    }

    private static class DoubleTypeConverter
    implements Function<String, Object> {
        private DoubleTypeConverter() {
        }

        public Double apply(String value) {
            return Double.valueOf(value);
        }
    }

    private static class CharacterTypeConverter
    implements Function<String, Object> {
        private CharacterTypeConverter() {
        }

        public Character apply(String value) {
            return Character.valueOf(value.charAt(0));
        }
    }

    private static class ByteTypeConverter
    implements Function<String, Object> {
        private ByteTypeConverter() {
        }

        public Byte apply(String value) {
            return Byte.valueOf(value);
        }
    }

    private static class BooleanTypeConverter
    implements Function<String, Object> {
        private BooleanTypeConverter() {
        }

        public Boolean apply(String value) {
            if ("true".equalsIgnoreCase(value) || value.isEmpty()) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Invalid value for boolean: " + value);
        }
    }

    private static class MultipleChoiceValidator
    implements Function<String, Object> {
        private final Function<String, Object> _inner;
        private final List<String> _values;

        public MultipleChoiceValidator(Function<String, Object> inner, List<String> values) {
            this._inner = inner;
            this._values = values;
        }

        public Object apply(String value) {
            if (!this._values.contains(value)) {
                throw new IllegalArgumentException("Invalid value: " + value);
            }
            return this._inner.apply((Object)value);
        }
    }

    private static class CheckOptionsKnownHandler
    implements Handler {
        private final Set<String> _known;

        private CheckOptionsKnownHandler(Set<String> names) {
            this._known = names;
        }

        @Override
        public void apply(Object object, Args args) throws IllegalAccessException {
            ImmutableSet supplied = args.options().keySet();
            Sets.SetView unknown = Sets.difference((Set)supplied, this._known);
            if (!unknown.isEmpty()) {
                throw new IllegalArgumentException("Unknown option" + (unknown.size() > 1 ? "s" : "") + ": " + AS_COMMA_LIST.join((Iterable)unknown));
            }
        }

        @Override
        public int getMaxArguments() {
            return Integer.MAX_VALUE;
        }
    }

    private static class CommandLineHandler
    extends FieldHandler {
        private final String command;

        private CommandLineHandler(Command command, Field field) {
            super(field);
            this.command = command.name();
        }

        @Override
        protected Object getValue(Args args) {
            return args.optc() == 0 && args.argc() == 0 ? this.command : this.command + " " + args;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }
    }

    private static class ArgsHandler
    extends FieldHandler {
        private ArgsHandler(Field field) {
            super(field);
        }

        @Override
        protected Object getValue(Args args) {
            return args;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }
    }

    private static class SplittingOptionHandler
    extends FieldHandler {
        private final Function<String, Object> _typeConverter;
        private final Option _option;
        private final Splitter _splitter;

        public SplittingOptionHandler(Field field, Function<String, Object> typeConverter, Option option) {
            super(field);
            this._typeConverter = typeConverter;
            this._option = option;
            this._splitter = Splitter.on((String)option.separator());
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        @Override
        protected Object getValue(Args args) {
            ImmutableList values = args.getOptions(this._option.name());
            if (!values.isEmpty()) {
                ArrayList fragments = Lists.newArrayList();
                for (String value : values) {
                    if (value.isEmpty()) continue;
                    Iterables.addAll((Collection)fragments, (Iterable)this._splitter.split((CharSequence)value));
                }
                return Iterables.toArray((Iterable)Iterables.transform((Iterable)fragments, this._typeConverter), this._field.getType().getComponentType());
            }
            if (this._option.required()) {
                throw new IllegalArgumentException("Option " + this._option.name() + " is required");
            }
            return null;
        }
    }

    private static class MultiValuedOptionHandler
    extends FieldHandler {
        private final Function<String, Object> _typeConverter;
        private final Option _option;

        public MultiValuedOptionHandler(Field field, Function<String, Object> typeConverter, Option option) {
            super(field);
            this._typeConverter = typeConverter;
            this._option = option;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        @Override
        protected Object getValue(Args args) {
            ImmutableList values = args.getOptions(this._option.name());
            if (!values.isEmpty()) {
                return Iterables.toArray((Iterable)Iterables.transform((Iterable)values, this._typeConverter), this._field.getType().getComponentType());
            }
            if (this._option.required()) {
                throw new IllegalArgumentException("Option " + this._option.name() + " is required");
            }
            return null;
        }
    }

    private static class OptionHandler
    extends FieldHandler {
        private final Function<String, Object> _typeConverter;
        private final Option _option;

        public OptionHandler(Field field, Function<String, Object> typeConverter, Option option) {
            super(field);
            this._typeConverter = typeConverter;
            this._option = option;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        @Override
        protected Object getValue(Args args) {
            String value = args.getOption(this._option.name());
            if (value != null) {
                return this._typeConverter.apply((Object)value);
            }
            if (this._option.required()) {
                throw new IllegalArgumentException("Option " + this._option.name() + " is required");
            }
            return null;
        }
    }

    private static class MultiValuedArgumentHandler
    extends FieldHandler {
        private final Function<String, Object> _typeConverter;
        private final Argument _argument;

        public MultiValuedArgumentHandler(Field field, Function<String, Object> typeConverter, Argument argument) {
            super(field);
            if (argument.index() < 0) {
                throw new IllegalArgumentException("Negative index is not allowed for multi valued arguments");
            }
            this._typeConverter = typeConverter;
            this._argument = argument;
        }

        @Override
        public int getMaxArguments() {
            return Integer.MAX_VALUE;
        }

        @Override
        protected Object getValue(Args args) {
            int index = this._argument.index();
            if (index < args.argc()) {
                Class<?> type = this._field.getType().getComponentType();
                Object values = Array.newInstance(type, args.argc() - index);
                for (int i = index; i < args.argc(); ++i) {
                    Object value = this._typeConverter.apply((Object)args.argv(i));
                    Array.set(values, i - index, value);
                }
                return values;
            }
            if (this._argument.required()) {
                throw new IllegalArgumentException("Argument " + (index + 1) + " is required");
            }
            return null;
        }
    }

    private static class ArgumentHandler
    extends FieldHandler {
        private final Function<String, Object> _typeConverter;
        private final Argument _argument;

        public ArgumentHandler(Field field, Function<String, Object> typeConverter, Argument argument) {
            super(field);
            this._typeConverter = typeConverter;
            this._argument = argument;
        }

        @Override
        public int getMaxArguments() {
            return this._argument.index() >= 0 ? this._argument.index() + 1 : -this._argument.index();
        }

        @Override
        protected Object getValue(Args args) {
            int index = this._argument.index();
            if (index < 0) {
                index += args.argc();
            }
            if (0 <= index && index < args.argc()) {
                return this._typeConverter.apply((Object)args.argv(index));
            }
            if (this._argument.required()) {
                throw new IllegalArgumentException("Argument " + (index + 1) + " is required");
            }
            return null;
        }
    }

    private static abstract class FieldHandler
    implements Handler {
        protected final Field _field;

        public FieldHandler(Field field) {
            this._field = field;
            this._field.setAccessible(true);
        }

        protected abstract Object getValue(Args var1);

        @Override
        public void apply(Object object, Args args) throws IllegalAccessException {
            Object value = this.getValue(args);
            if (value != null) {
                this._field.set(object, value);
            }
        }
    }

    private static class MaxArgumentsHandler
    implements Handler {
        private final int _max;

        public MaxArgumentsHandler(int max) {
            this._max = max;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        @Override
        public void apply(Object object, Args args) throws IllegalAccessException {
            if (args.argc() > this._max) {
                throw new IllegalArgumentException("Too many arguments: " + Joiner.on((String)" ").join((Iterable)args.getArguments().subList(this._max, args.argc())));
            }
        }
    }

    private static interface Handler {
        public void apply(Object var1, Args var2) throws IllegalAccessException;

        public int getMaxArguments();
    }
}

