/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringProxy<T>
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MonitoringProxy.class);
    private final T monitoredObject;
    private final RequestCounters<Method> counter;
    private final RequestExecutionTimeGauges<Method> gauge;

    private MonitoringProxy(T monitoredObject, RequestCounters<Method> counter, RequestExecutionTimeGauges<Method> gauge) {
        this.monitoredObject = monitoredObject;
        this.counter = counter;
        this.gauge = gauge;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long startTimeStamp = System.currentTimeMillis();
        if (this.counter != null) {
            this.counter.incrementRequests(method);
        }
        try {
            Object result;
            Object object = result = method.invoke(this.monitoredObject, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (this.counter != null) {
                this.counter.incrementFailed(method);
            }
            throw e.getTargetException();
        }
        finally {
            long execTime = System.currentTimeMillis() - startTimeStamp;
            if (logger.isDebugEnabled()) {
                logger.debug("invocation of " + method + " took " + execTime + " ms");
            }
            if (this.gauge != null) {
                this.gauge.update(method, execTime);
            }
        }
    }

    public static <T> T decorateWithMonitoringProxy(Class<?>[] interfaces, T monitoringObject, RequestCounters<Method> counter, RequestExecutionTimeGauges<Method> gauge) {
        MonitoringProxy<T> monitoringHandler = new MonitoringProxy<T>(monitoringObject, counter, gauge);
        return (T)Proxy.newProxyInstance(monitoringObject.getClass().getClassLoader(), interfaces, monitoringHandler);
    }
}

