/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import java.io.Serializable;
import java.util.regex.Pattern;

public class Glob
implements Serializable {
    private static final long serialVersionUID = -5052804169005574207L;
    private static final CharMatcher WILDCARD = CharMatcher.anyOf((CharSequence)"*?");
    private final String _pattern;

    public Glob(String s) {
        this._pattern = s;
    }

    public boolean matches(String s) {
        return this.toPattern().matcher(s).matches();
    }

    public boolean isGlob() {
        return WILDCARD.matchesAnyOf((CharSequence)this._pattern);
    }

    public String toString() {
        return this._pattern;
    }

    public Pattern toPattern() {
        return Glob.parseGlobToPattern(this._pattern);
    }

    public String toSql() {
        return Glob.parseGlobToSql(this._pattern);
    }

    public static String parseGlobToSql(String glob) {
        StringBuilder s = new StringBuilder(glob.length() * 2 + 2);
        int j = 0;
        block4: for (int i = 0; i < glob.length(); ++i) {
            switch (glob.charAt(i)) {
                case '?': {
                    s.append(Glob.quoteSql(glob.substring(j, i)));
                    s.append("_");
                    j = i + 1;
                    continue block4;
                }
                case '*': {
                    s.append(Glob.quoteSql(glob.substring(j, i)));
                    s.append("%");
                    j = i + 1;
                    continue block4;
                }
            }
        }
        s.append(Glob.quoteSql(glob.substring(j)));
        return s.toString();
    }

    private static String quoteSql(String s) {
        return s.replace("\\", "\\\\").replace("_", "\\_").replace("%", "\\%");
    }

    public static Pattern parseGlobToPattern(String glob) {
        StringBuilder s = new StringBuilder(glob.length() * 2 + 2);
        int j = 0;
        s.append("^");
        block4: for (int i = 0; i < glob.length(); ++i) {
            switch (glob.charAt(i)) {
                case '?': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append(".");
                    j = i + 1;
                    continue block4;
                }
                case '*': {
                    s.append(Pattern.quote(glob.substring(j, i)));
                    s.append(".*");
                    j = i + 1;
                    continue block4;
                }
            }
        }
        s.append(Pattern.quote(glob.substring(j)));
        s.append("$");
        return Pattern.compile(s.toString());
    }
}

