/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.CharMatcher;
import java.net.URI;
import java.net.URISyntaxException;

public class StringMarkup {
    private static final CharMatcher QUOTE_STRING_SPECIAL = CharMatcher.anyOf((CharSequence)"\\\"");
    private static final String SCHEME_FILE = "file";
    private static final int SCHEME_FILE_LENGTH = "file".length();

    public static StringBuilder quotedString(StringBuilder sb, String src) {
        sb.append('\"');
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (QUOTE_STRING_SPECIAL.matches(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb;
    }

    public static String quotedString(String src) {
        return StringMarkup.quotedString(new StringBuilder(), src).toString();
    }

    public static StringBuilder percentEncode(StringBuilder sb, String src) {
        return sb.append(StringMarkup.percentEncode(src));
    }

    public static String percentEncode(String src) {
        URI uri;
        try {
            uri = new URI(SCHEME_FILE, null, "/" + src, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("illegal path element: " + e.getMessage(), e);
        }
        String encoded = uri.toASCIIString();
        int idx = SCHEME_FILE_LENGTH + 2;
        return encoded.substring(idx, encoded.length());
    }
}

