/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class AccessLatency
implements Serializable {
    private static final long serialVersionUID = -6473179157424112725L;
    private final String _name;
    private final int _id;
    public static final AccessLatency ONLINE = new AccessLatency("ONLINE", 1);
    public static final AccessLatency NEARLINE = new AccessLatency("NEARLINE", 0);

    private AccessLatency(String name, int id) {
        this._name = name;
        this._id = id;
    }

    public static AccessLatency[] getAllLatencies() {
        return new AccessLatency[]{ONLINE, NEARLINE};
    }

    public String toString() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public static AccessLatency getAccessLatency(String latency) throws IllegalArgumentException {
        if (latency == null || latency.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (AccessLatency.ONLINE._name.equalsIgnoreCase(latency)) {
            return ONLINE;
        }
        if (AccessLatency.NEARLINE._name.equalsIgnoreCase(latency)) {
            return NEARLINE;
        }
        try {
            int id = Integer.parseInt(latency);
            return AccessLatency.getAccessLatency(id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown AccessLatency");
        }
    }

    public static AccessLatency getAccessLatency(int id) throws IllegalArgumentException {
        if (AccessLatency.ONLINE._id == id) {
            return ONLINE;
        }
        if (AccessLatency.NEARLINE._id == id) {
            return NEARLINE;
        }
        throw new IllegalArgumentException("Unknown AccessLatency Id");
    }

    public boolean equals(Object obj) {
        return obj instanceof AccessLatency && ((AccessLatency)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static AccessLatency valueOf(String value) {
        return AccessLatency.getAccessLatency(value);
    }

    public Object readResolve() throws ObjectStreamException {
        return AccessLatency.getAccessLatency(this.getId());
    }
}

