/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import java.security.Principal;

public class LoginGidPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -719644742571312959L;
    private long _gid;

    public LoginGidPrincipal(long gid) {
        if (gid < 0L) {
            throw new IllegalArgumentException("GID must be non-negative");
        }
        this._gid = gid;
    }

    public LoginGidPrincipal(String gid) {
        this(Long.parseLong(gid));
    }

    public long getGid() {
        return this._gid;
    }

    @Override
    public String getName() {
        return String.valueOf(this._gid);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LoginGidPrincipal)) {
            return false;
        }
        LoginGidPrincipal other = (LoginGidPrincipal)obj;
        return other._gid == this._gid;
    }

    @Override
    public int hashCode() {
        return (int)this._gid;
    }
}

