/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.lang.management.ManagementFactory;
import java.util.Formatter;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dcache.commons.stats.RequestCounterMXBean;

public class RequestCounterImpl
implements RequestCounterMXBean {
    private final String name;
    private int requests;
    private int failed;
    private ObjectName mxBeanName;

    public RequestCounterImpl(String name, String family) {
        this.name = name;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            String mxName = String.format("%s:type=RequestCounter,family=%s,name=%s", this.getClass().getPackage().getName(), family, this.name);
            this.mxBeanName = new ObjectName(mxName);
            if (!server.isRegistered(this.mxBeanName)) {
                server.registerMBean(this, this.mxBeanName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            this.mxBeanName = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized String toString() {
        String aName = this.name;
        if (this.name.length() > 34) {
            aName = aName.substring(0, 34);
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter formatter = new Formatter(sb);){
            formatter.format("%-34s %9d %9d", aName, this.requests, this.failed);
        }
        return sb.toString();
    }

    @Override
    public synchronized int getTotalRequests() {
        return this.requests;
    }

    @Override
    public synchronized void reset() {
        this.requests = 0;
        this.failed = 0;
    }

    @Override
    public synchronized void shutdown() {
        if (this.mxBeanName != null) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                server.unregisterMBean(this.mxBeanName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                // empty catch block
            }
        }
    }

    public synchronized void incrementRequests(int requests) {
        this.requests += requests;
    }

    public synchronized void incrementRequests() {
        ++this.requests;
    }

    @Override
    public synchronized int getFailed() {
        return this.failed;
    }

    public synchronized void incrementFailed(int failed) {
        this.failed += failed;
    }

    public synchronized void incrementFailed() {
        ++this.failed;
    }

    public synchronized int getSuccessful() {
        return this.requests - this.failed;
    }
}

