/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

public enum ChecksumType {
    ADLER32(1, "ADLER32", 32),
    MD5_TYPE(2, "MD5", 128),
    MD4_TYPE(3, "MD4", 128);

    private final int type;
    private final String name;
    private final int bits;

    private ChecksumType(int type, String name, int bits) {
        this.type = type;
        this.name = name;
        this.bits = bits;
    }

    public static final ChecksumType getChecksumType(int i) {
        for (ChecksumType type : ChecksumType.values()) {
            if (type.type != i) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checksum type: " + i);
    }

    public static final ChecksumType getChecksumType(String s) {
        for (ChecksumType type : ChecksumType.values()) {
            if (!type.name.equalsIgnoreCase(s) && !String.valueOf(type.type).equals(s)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checksum type: " + s);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getBits() {
        return this.bits;
    }

    public int getNibbles() {
        return (this.bits + 3) / 4;
    }
}

