/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dcache.util.Subnet;

public class IPMatcher {
    private static final int IPv4_FULL_MASK = 32;
    private static final int IPv6_FULL_MASK = 128;
    private static final int IPv6_HALF_MASK = 64;

    public static int convertToCidrIfIsIPv4Mask(String maskString) {
        int mask;
        if (maskString.contains(".")) {
            mask = Ints.fromByteArray((byte[])InetAddresses.forString((String)maskString).getAddress());
            mask = 32 - Integer.numberOfTrailingZeros(mask);
        } else {
            mask = Integer.parseInt(maskString);
        }
        return mask;
    }

    public static InetAddress maskInetAddress(InetAddress inetAddress, int mask) throws UnknownHostException {
        byte[] address = inetAddress.getAddress();
        if (mask == 0) {
            return InetAddress.getByAddress(new byte[address.length]);
        }
        if (mask % 8 != 0) {
            address[mask / 8] = (byte)(address[mask / 8] & 255 << 8 - mask % 8);
        }
        for (int i = mask / 8 + 1; i < address.length; ++i) {
            address[i] = 0;
        }
        return InetAddress.getByAddress(address);
    }

    public static boolean matchCidrPattern(InetAddress inetAddress, String cidrPattern) {
        return Subnet.create(cidrPattern).contains(inetAddress);
    }

    public static boolean matchAny(InetAddress[] ips, InetAddress subnet, int mask) {
        for (InetAddress inetAddress : ips) {
            if (!IPMatcher.match(inetAddress, subnet, mask)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(InetAddress ip, InetAddress subnet, int mask) {
        byte[] netBytes;
        Preconditions.checkArgument((mask >= 0 ? 1 : 0) != 0, (Object)"Netmask should be positive");
        if (mask == 0) {
            return true;
        }
        byte[] ipBytes = ip.getAddress();
        if (ipBytes.length != (netBytes = subnet.getAddress()).length) {
            return false;
        }
        if (ipBytes.length == 4) {
            Preconditions.checkArgument((mask <= 32 ? 1 : 0) != 0, (Object)"Netmask for IPv4 can't be bigger than32");
            int ipAsInt = Ints.fromByteArray((byte[])ipBytes);
            int netAsBytes = Ints.fromByteArray((byte[])netBytes);
            return (ipAsInt ^ netAsBytes) >> 32 - mask == 0;
        }
        Preconditions.checkArgument((mask <= 128 ? 1 : 0) != 0, (Object)"Netmask for IPv6 can't be bigger than128");
        long ipAsLong0 = Longs.fromBytes((byte)ipBytes[0], (byte)ipBytes[1], (byte)ipBytes[2], (byte)ipBytes[3], (byte)ipBytes[4], (byte)ipBytes[5], (byte)ipBytes[6], (byte)ipBytes[7]);
        long netAsLong0 = Longs.fromBytes((byte)netBytes[0], (byte)netBytes[1], (byte)netBytes[2], (byte)netBytes[3], (byte)netBytes[4], (byte)netBytes[5], (byte)netBytes[6], (byte)netBytes[7]);
        if (mask > 64) {
            long ipAsLong1 = Longs.fromBytes((byte)ipBytes[8], (byte)ipBytes[9], (byte)ipBytes[10], (byte)ipBytes[11], (byte)ipBytes[12], (byte)ipBytes[13], (byte)ipBytes[14], (byte)ipBytes[15]);
            long netAsLong1 = Longs.fromBytes((byte)netBytes[8], (byte)netBytes[9], (byte)netBytes[10], (byte)netBytes[11], (byte)netBytes[12], (byte)netBytes[13], (byte)netBytes[14], (byte)netBytes[15]);
            return ipAsLong0 == netAsLong0 & (ipAsLong1 ^ netAsLong1) >> 128 - mask == 0L;
        }
        return (ipAsLong0 ^ netAsLong0) >> 64 - mask == 0L;
    }

    public static InetAddress tryConvertToIPv4(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet6Address)) {
            return inetAddress;
        }
        try {
            return InetAddresses.getEmbeddedIPv4ClientAddress((Inet6Address)((Inet6Address)inetAddress));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return inetAddress;
        }
    }
}

