/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;

public abstract class NetworkUtils {
    public static final String LOCAL_HOST_ADDRESS_PROPERTY = "org.dcache.net.localaddresses";
    private static final String canonicalHostName;
    private static final int RANDOM_PORT = 23241;
    private static final int FIRST_CLIENT_HOST = 0;
    private static final List<InetAddress> LOCAL_INET_ADDRESSES;
    private static final boolean FAKED_ADDRESS;

    public static String getCanonicalHostName() {
        return canonicalHostName;
    }

    public static Comparator<InetAddress> getExternalInternalSorter() {
        return new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress arg0, InetAddress arg1) {
                if (arg0.isLinkLocalAddress() || arg0.isLoopbackAddress() || arg0.isSiteLocalAddress() || arg0.isMulticastAddress()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static List<InetAddress> getLocalAddresses() {
        return LOCAL_INET_ADDRESSES;
    }

    public static List<InetAddress> getLocalAddressesV4() throws SocketException {
        return ImmutableList.copyOf((Collection)Collections2.filter(NetworkUtils.getLocalAddresses(), (Predicate)Predicates.instanceOf(Inet4Address.class)));
    }

    public static InetAddress getLocalAddressForClient(String[] clientHosts) throws SocketException, UnknownHostException {
        InetAddress clientAddress = InetAddress.getByName(clientHosts[0]);
        InetAddress localAddress = NetworkUtils.getLocalAddress(clientAddress);
        return localAddress;
    }

    public static URL toURL(URI uri) throws URISyntaxException {
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            URISyntaxException exception = new URISyntaxException(uri.toString(), e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public static InetAddress getLocalAddress(InetAddress intendedDestination) throws SocketException {
        return NetworkUtils.getLocalAddress(intendedDestination, NetworkUtils.getProtocolFamily(intendedDestination));
    }

    public static InetAddress getLocalAddress(InetAddress intendedDestination, ProtocolFamily protocolFamily) throws SocketException {
        if (FAKED_ADDRESS) {
            for (InetAddress address : LOCAL_INET_ADDRESSES) {
                if (NetworkUtils.getProtocolFamily(address) != protocolFamily) continue;
                return address;
            }
            return null;
        }
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(intendedDestination, 23241);
            InetAddress localAddress = socket.getLocalAddress();
            if (localAddress.isAnyLocalAddress()) {
                if (intendedDestination.isLoopbackAddress()) {
                    localAddress = InetAddress.getLoopbackAddress();
                } else {
                    try {
                        localAddress = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        localAddress = NetworkUtils.getLocalAddresses().get(0);
                    }
                }
            }
            if (NetworkUtils.getProtocolFamily(localAddress) != protocolFamily) {
                Enumeration<InetAddress> addresses = NetworkInterface.getByInetAddress(localAddress).getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (NetworkUtils.getProtocolFamily(address) != protocolFamily || address.isMulticastAddress() || address.isLoopbackAddress() && !intendedDestination.isLoopbackAddress() || address.isSiteLocalAddress() && !intendedDestination.isSiteLocalAddress() || address.isLinkLocalAddress() && !intendedDestination.isLinkLocalAddress()) continue;
                    localAddress = address;
                    break;
                }
            }
            InetAddress inetAddress = localAddress;
            return inetAddress;
        }
    }

    private static ProtocolFamily getProtocolFamily(InetAddress address) {
        if (address instanceof Inet4Address) {
            return StandardProtocolFamily.INET;
        }
        if (address instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        throw new IllegalArgumentException("Unknown protocol family: " + address);
    }

    private static String getPreferredHostName() {
        String hostName = "localhost";
        if (!LOCAL_INET_ADDRESSES.isEmpty()) {
            InetAddress[] addresses = LOCAL_INET_ADDRESSES.toArray(new InetAddress[0]);
            Arrays.sort(addresses, NetworkUtils.getExternalInternalSorter());
            boolean found = false;
            for (InetAddress a : addresses) {
                hostName = NetworkUtils.stripScope(a.getCanonicalHostName());
                if (InetAddresses.isInetAddress((String)hostName)) continue;
                found = true;
                break;
            }
            if (!found) {
                hostName = addresses[0].getCanonicalHostName();
            }
        }
        return hostName;
    }

    private static String stripScope(String hostName) {
        int i = hostName.indexOf("%");
        if (i > 0) {
            return hostName.substring(0, i);
        }
        return hostName;
    }

    static {
        String localaddresses = System.getProperty(LOCAL_HOST_ADDRESS_PROPERTY);
        ArrayList<InetAddress> localInetAddress = new ArrayList<InetAddress>();
        if (localaddresses != null && !localaddresses.isEmpty()) {
            FAKED_ADDRESS = true;
            Splitter s = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (String address : s.split((CharSequence)localaddresses)) {
                localInetAddress.add(InetAddresses.forString((String)address));
            }
        } else {
            FAKED_ADDRESS = false;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface i = interfaces.nextElement();
                    try {
                        if (!i.isUp() || i.isLoopback()) continue;
                        Enumeration<InetAddress> addresses = i.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            localInetAddress.add(addresses.nextElement());
                        }
                    }
                    catch (SocketException e) {
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        LOCAL_INET_ADDRESSES = ImmutableList.copyOf(localInetAddress);
        canonicalHostName = NetworkUtils.getPreferredHostName();
    }
}

